/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.hccake.ballcat.common.xss.cleaner.XssCleaner;
import com.hccake.ballcat.common.xss.core.XssStateHolder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssStringJsonDeserializer
extends StringDeserializer {
    private static final Logger log = LoggerFactory.getLogger(XssStringJsonDeserializer.class);
    private final XssCleaner xssCleaner;

    public XssStringJsonDeserializer(XssCleaner xssCleaner) {
        this.xssCleaner = xssCleaner;
    }

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this.getCleanText(p.getText());
        }
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_ARRAY) {
            return (String)this._deserializeFromArray(p, ctxt);
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return ctxt.getBase64Variant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        if (t == JsonToken.START_OBJECT) {
            return ctxt.extractScalarFromObject(p, (JsonDeserializer)this, this._valueClass);
        }
        if (t.isScalarValue()) {
            String text = p.getValueAsString();
            return this.getCleanText(text);
        }
        return (String)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    private String getCleanText(String text) {
        if (text == null) {
            return null;
        }
        return XssStateHolder.enabled() ? this.xssCleaner.clean(text) : text;
    }
}

