/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.hccake.ballcat.common.xss.cleaner.XssCleaner;
import com.hccake.ballcat.common.xss.core.XssStateHolder;
import java.io.IOException;

public class XssStringJsonSerializer
extends JsonSerializer<String> {
    private final XssCleaner xssCleaner;

    public XssStringJsonSerializer(XssCleaner xssCleaner) {
        this.xssCleaner = xssCleaner;
    }

    public Class<String> handledType() {
        return String.class;
    }

    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (value != null) {
            if (XssStateHolder.enabled()) {
                value = this.xssCleaner.clean(value);
            }
            jsonGenerator.writeString(value);
        }
    }
}

