/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.resource;

import com.hccake.ballcat.common.security.component.CustomPermissionEvaluator;
import java.util.List;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.BallcatOauth2ResourceServerSecurityFilterChainBuilder;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.OAuth2ResourceServerConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.OAuth2ResourceServerExtensionConfigurer;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.Oauth2ResourceServerSecurityFilterChainBuilder;
import org.ballcat.springsecurity.oauth2.server.resource.introspection.BallcatRemoteOpaqueTokenIntrospector;
import org.ballcat.springsecurity.oauth2.server.resource.properties.OAuth2ResourceServerProperties;
import org.ballcat.springsecurity.oauth2.server.resource.web.CustomAuthenticationEntryPoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(proxyBeanMethods=false)
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableConfigurationProperties(value={OAuth2ResourceServerProperties.class})
public class OAuth2ResourceServerAutoConfiguration {
    public static final String OAUTH2_RESOURCE_SERVER_SECURITY_FILTER_CHAIN_BEAN_NAME = "oauth2ResourceServerSecurityFilterChain";

    @Bean
    @ConditionalOnMissingBean(name={"oauth2ResourceServerSecurityFilterChain"}, value={Oauth2ResourceServerSecurityFilterChainBuilder.class})
    public Oauth2ResourceServerSecurityFilterChainBuilder oauth2ResourceServerSecurityFilterChainBuilder(OAuth2ResourceServerProperties oAuth2ResourceServerProperties, AuthenticationEntryPoint authenticationEntryPoint, BearerTokenResolver bearerTokenResolver, ObjectProvider<List<OAuth2ResourceServerConfigurerCustomizer>> configurerCustomizersProvider, ObjectProvider<List<OAuth2ResourceServerExtensionConfigurer<HttpSecurity>>> extensionConfigurersProvider) {
        return new BallcatOauth2ResourceServerSecurityFilterChainBuilder(oAuth2ResourceServerProperties, authenticationEntryPoint, bearerTokenResolver, configurerCustomizersProvider, extensionConfigurersProvider);
    }

    @Bean(name={"oauth2ResourceServerSecurityFilterChain"})
    @Order(value=99)
    @ConditionalOnMissingBean(name={"oauth2ResourceServerSecurityFilterChain"})
    public SecurityFilterChain oauth2ResourceServerSecurityFilterChain(Oauth2ResourceServerSecurityFilterChainBuilder builder, HttpSecurity httpSecurity) throws Exception {
        return builder.build(httpSecurity);
    }

    @Bean(name={"per"})
    @ConditionalOnMissingBean(value={CustomPermissionEvaluator.class})
    public CustomPermissionEvaluator customPermissionEvaluator() {
        return new CustomPermissionEvaluator();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="ballcat.security.oauth2.resourceserver", name={"shared-stored-token"}, havingValue="false")
    public OpaqueTokenIntrospector opaqueTokenIntrospector(OAuth2ResourceServerProperties oAuth2ResourceServerProperties) {
        OAuth2ResourceServerProperties.Opaquetoken opaqueToken = oAuth2ResourceServerProperties.getOpaqueToken();
        return new BallcatRemoteOpaqueTokenIntrospector(opaqueToken.getIntrospectionUri(), opaqueToken.getClientId(), opaqueToken.getClientSecret());
    }

    @Bean
    @ConditionalOnMissingBean
    public OpaqueTokenAuthenticationProvider opaqueTokenAuthenticationProvider(OpaqueTokenIntrospector opaqueTokenIntrospector) {
        return new OpaqueTokenAuthenticationProvider(opaqueTokenIntrospector);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new CustomAuthenticationEntryPoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public BearerTokenResolver bearerTokenResolver() {
        DefaultBearerTokenResolver defaultBearerTokenResolver = new DefaultBearerTokenResolver();
        defaultBearerTokenResolver.setAllowUriQueryParameter(true);
        return defaultBearerTokenResolver;
    }
}

