/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.resource.introspection;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.common.security.userdetails.ClientPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

public class SpringAuthorizationServerSharedStoredOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private static final Logger log = LoggerFactory.getLogger(SpringAuthorizationServerSharedStoredOpaqueTokenIntrospector.class);
    private static final String AUTHORITY_SCOPE_PREFIX = "SCOPE_";
    private final OAuth2AuthorizationService authorizationService;

    public SpringAuthorizationServerSharedStoredOpaqueTokenIntrospector(OAuth2AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public OAuth2AuthenticatedPrincipal introspect(String accessTokenValue) {
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessTokenValue, null);
        if (authorization == null) {
            if (log.isTraceEnabled()) {
                log.trace("Did not authenticate token introspection request since token was not found");
            }
            throw new BadOpaqueTokenException("Invalid access token: " + accessTokenValue);
        }
        OAuth2Authorization.Token authorizedToken = authorization.getToken(accessTokenValue);
        if (authorizedToken == null || !authorizedToken.isActive()) {
            if (log.isTraceEnabled()) {
                log.trace("Did not validate token since it is inactive");
            }
            throw new BadOpaqueTokenException("Provided token isn't active");
        }
        AuthorizationGrantType authorizationGrantType = authorization.getAuthorizationGrantType();
        if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)authorizationGrantType)) {
            return this.getClientPrincipal(authorization);
        }
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = (UsernamePasswordAuthenticationToken)authorization.getAttributes().get("java.security.Principal");
        return (OAuth2AuthenticatedPrincipal)usernamePasswordAuthenticationToken.getPrincipal();
    }

    private ClientPrincipal getClientPrincipal(OAuth2Authorization oAuth2Authentication) {
        Set authorizedScopes = oAuth2Authentication.getAuthorizedScopes();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (CollUtil.isNotEmpty((Collection)authorizedScopes)) {
            for (String scope : authorizedScopes) {
                authorities.add(new SimpleGrantedAuthority(AUTHORITY_SCOPE_PREFIX + scope));
            }
        }
        ClientPrincipal clientPrincipal = new ClientPrincipal(oAuth2Authentication.getPrincipalName(), new HashMap(8), authorities);
        clientPrincipal.setScope((Collection)authorizedScopes);
        return clientPrincipal;
    }
}

