/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.core.constant.GlobalConstants;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.domain.SelectData;
import com.hccake.ballcat.common.model.entity.BaseEntity;
import com.hccake.ballcat.common.model.entity.LogicDeletedBaseEntity;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.model.qo.SysUserQO;
import com.hccake.ballcat.system.model.vo.SysUserPageVO;
import com.hccake.extend.mybatis.plus.conditions.query.LambdaAliasQueryWrapperX;
import com.hccake.extend.mybatis.plus.conditions.query.LambdaQueryWrapperX;
import com.hccake.extend.mybatis.plus.mapper.ExtendMapper;
import com.hccake.extend.mybatis.plus.toolkit.WrappersX;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface SysUserMapper
extends ExtendMapper<SysUser> {
    default public PageResult<SysUserPageVO> queryPage(PageParam pageParam, SysUserQO qo) {
        IPage page = this.prodPage(pageParam);
        LambdaAliasQueryWrapperX wrapperX = WrappersX.lambdaAliasQueryX(SysUser.class);
        ((LambdaQueryWrapperX)wrapperX.eq(LogicDeletedBaseEntity::getDeleted, (Object)GlobalConstants.NOT_DELETED_FLAG)).likeIfPresent(SysUser::getUsername, (Object)qo.getUsername()).likeIfPresent(SysUser::getEmail, (Object)qo.getEmail()).likeIfPresent(SysUser::getPhoneNumber, (Object)qo.getPhoneNumber()).likeIfPresent(SysUser::getNickname, (Object)qo.getNickname()).eqIfPresent(SysUser::getStatus, (Object)qo.getStatus()).eqIfPresent(SysUser::getGender, (Object)qo.getGender()).eqIfPresent(SysUser::getType, (Object)qo.getType()).inIfPresent(SysUser::getOrganizationId, (Collection)qo.getOrganizationId());
        if (StringUtils.isNotBlank((CharSequence)qo.getStartTime()) && StringUtils.isNotBlank((CharSequence)qo.getEndTime())) {
            wrapperX.between(BaseEntity::getCreateTime, (Object)qo.getStartTime(), (Object)qo.getEndTime());
        }
        this.selectByPage((IPage<SysUserPageVO>)page, (Wrapper<SysUser>)wrapperX);
        return new PageResult(page.getRecords(), page.getTotal());
    }

    public IPage<SysUserPageVO> selectByPage(IPage<SysUserPageVO> var1, @Param(value="ew") Wrapper<SysUser> var2);

    default public boolean updateUserStatusBatch(Collection<Long> userIds, Integer status) {
        int i = this.update(null, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysUser.class).set(SysUser::getStatus, (Object)status)).in(SysUser::getUserId, userIds));
        return SqlHelper.retBool((Integer)i);
    }

    default public SysUser selectByUsername(String username) {
        return (SysUser)this.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysUser::getUsername, (Object)username));
    }

    default public boolean updatePassword(Long userId, String password) {
        int i = this.update(null, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysUser::getUserId, (Object)userId)).set(SysUser::getPassword, (Object)password));
        return SqlHelper.retBool((Integer)i);
    }

    default public List<SysUser> listByOrganizationIds(Collection<Long> organizationIds) {
        return this.selectList((Wrapper)Wrappers.lambdaQuery().in(SysUser::getOrganizationId, organizationIds));
    }

    default public List<SysUser> listByUserTypes(Collection<Integer> userTypes) {
        return this.selectList((Wrapper)Wrappers.lambdaQuery().in(SysUser::getType, userTypes));
    }

    default public List<SysUser> listByUserIds(Collection<Long> userIds) {
        return this.selectList((Wrapper)Wrappers.lambdaQuery().in(SysUser::getUserId, userIds));
    }

    public List<SysUser> listByRoleCodes(@Param(value="roleCodes") Collection<String> var1);

    public List<SelectData<Void>> listSelectData(@Param(value="userTypes") Collection<Integer> var1);

    default public boolean existsForOrganization(Long organizationId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(SysUser.class).eq(SysUser::getOrganizationId, (Object)organizationId);
        Long count = this.selectCount((Wrapper)wrapper);
        return SqlHelper.retBool((Long)count);
    }
}

