/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.i18n.I18nMessageCreateEvent;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.system.converter.SysMenuConverter;
import com.hccake.ballcat.system.mapper.SysMenuMapper;
import com.hccake.ballcat.system.model.dto.SysMenuCreateDTO;
import com.hccake.ballcat.system.model.dto.SysMenuUpdateDTO;
import com.hccake.ballcat.system.model.entity.SysMenu;
import com.hccake.ballcat.system.model.qo.SysMenuQO;
import com.hccake.ballcat.system.service.SysMenuService;
import com.hccake.ballcat.system.service.SysRoleMenuService;
import com.hccake.extend.mybatis.plus.service.impl.ExtendServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuServiceImpl
extends ExtendServiceImpl<SysMenuMapper, SysMenu>
implements SysMenuService {
    private static final Logger log = LoggerFactory.getLogger(SysMenuServiceImpl.class);
    private final SysRoleMenuService sysRoleMenuService;
    private final ApplicationEventPublisher eventPublisher;

    public boolean save(SysMenu sysMenu) {
        Long menuId = sysMenu.getId();
        SysMenu existingMenu = (SysMenu)((SysMenuMapper)this.baseMapper).selectById(menuId);
        if (existingMenu != null) {
            String errorMessage = String.format("ID [%s] \u5df2\u88ab\u83dc\u5355 [%s] \u4f7f\u7528\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u83dc\u5355ID", menuId, existingMenu.getTitle());
            throw new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), errorMessage);
        }
        return SqlHelper.retBool((Integer)((SysMenuMapper)this.baseMapper).insert(sysMenu));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean create(SysMenuCreateDTO sysMenuCreateDTO) {
        SysMenu existingMenu;
        SysMenu sysMenu = SysMenuConverter.INSTANCE.createDtoToPo(sysMenuCreateDTO);
        Long menuId = sysMenu.getId();
        if (menuId != null && (existingMenu = (SysMenu)((SysMenuMapper)this.baseMapper).selectById(menuId)) != null) {
            String errorMessage = String.format("ID [%s] \u5df2\u88ab\u83dc\u5355 [%s] \u4f7f\u7528\uff0c\u8bf7\u66f4\u6362\u5176\u4ed6\u83dc\u5355ID", menuId, existingMenu.getTitle());
            throw new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), errorMessage);
        }
        boolean saveSuccess = SqlHelper.retBool((Integer)((SysMenuMapper)this.baseMapper).insert(sysMenu));
        Assert.isTrue((boolean)saveSuccess, () -> {
            log.error("[create] \u521b\u5efa\u83dc\u5355\u5931\u8d25\uff0csysMenuCreateDTO: {}", (Object)sysMenuCreateDTO);
            return new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u521b\u5efa\u83dc\u5355\u5931\u8d25");
        });
        List i18nMessages = sysMenuCreateDTO.getI18nMessages();
        if (CollUtil.isNotEmpty((Collection)i18nMessages)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new I18nMessageCreateEvent(i18nMessages));
        }
        return saveSuccess;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        Long subMenu = ((SysMenuMapper)this.baseMapper).countSubMenu(id);
        if (subMenu != null && subMenu > 0L) {
            throw new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), "\u83dc\u5355\u542b\u6709\u4e0b\u7ea7\u4e0d\u80fd\u5220\u9664");
        }
        this.sysRoleMenuService.deleteByMenuId(id);
        return SqlHelper.retBool((Integer)((SysMenuMapper)this.baseMapper).deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SysMenuUpdateDTO sysMenuUpdateDTO) {
        Long originalId = sysMenuUpdateDTO.getOriginalId();
        SysMenu sysMenu = SysMenuConverter.INSTANCE.updateDtoToPo(sysMenuUpdateDTO);
        boolean updateSuccess = ((SysMenuMapper)this.baseMapper).updateMenuAndId(originalId, sysMenu);
        Assert.isTrue((boolean)updateSuccess, () -> {
            log.error("[update] \u66f4\u65b0\u83dc\u5355\u6743\u9650\u65f6\uff0csql \u6267\u884c\u5f02\u5e38\uff0coriginalId\uff1a{}\uff0csysMenu\uff1a{}", (Object)originalId, (Object)sysMenu);
            return new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u66f4\u65b0\u83dc\u5355\u6743\u9650\u65f6\uff0csql \u6267\u884c\u5f02\u5e38");
        });
        Long menuId = sysMenuUpdateDTO.getId();
        if (originalId.equals(menuId)) {
            return;
        }
        this.sysRoleMenuService.updateMenuId(originalId, menuId);
        ((SysMenuMapper)this.baseMapper).updateParentId(originalId, menuId);
    }

    @Override
    public List<SysMenu> listOrderBySort(SysMenuQO sysMenuQO) {
        return ((SysMenuMapper)this.baseMapper).listOrderBySort(sysMenuQO);
    }

    @Override
    public List<SysMenu> listByRoleCode(String roleCode) {
        return ((SysMenuMapper)this.baseMapper).listByRoleCode(roleCode);
    }

    public SysMenuServiceImpl(SysRoleMenuService sysRoleMenuService, ApplicationEventPublisher eventPublisher) {
        this.sysRoleMenuService = sysRoleMenuService;
        this.eventPublisher = eventPublisher;
    }
}

