/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.core.constant.GlobalConstants;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.util.tree.TreeUtils;
import com.hccake.ballcat.system.converter.SysOrganizationConverter;
import com.hccake.ballcat.system.mapper.SysOrganizationMapper;
import com.hccake.ballcat.system.model.dto.OrganizationMoveChildParam;
import com.hccake.ballcat.system.model.dto.SysOrganizationDTO;
import com.hccake.ballcat.system.model.entity.SysOrganization;
import com.hccake.ballcat.system.model.qo.SysOrganizationQO;
import com.hccake.ballcat.system.model.vo.SysOrganizationTree;
import com.hccake.ballcat.system.service.SysOrganizationService;
import com.hccake.ballcat.system.service.SysUserService;
import com.hccake.extend.mybatis.plus.service.impl.ExtendServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysOrganizationServiceImpl
extends ExtendServiceImpl<SysOrganizationMapper, SysOrganization>
implements SysOrganizationService {
    private final SysUserService sysUserService;

    @Override
    public List<SysOrganizationTree> listTree(SysOrganizationQO sysOrganizationQO) {
        List list = this.list();
        List tree = TreeUtils.buildTree((List)list, (Object)GlobalConstants.TREE_ROOT_ID_LONG, arg_0 -> ((SysOrganizationConverter)SysOrganizationConverter.INSTANCE).poToTree(arg_0));
        String name = sysOrganizationQO.getName();
        if (CharSequenceUtil.isNotEmpty((CharSequence)name)) {
            return TreeUtils.pruneTree((List)tree, node -> node.getName() != null && node.getName().contains(name));
        }
        return tree;
    }

    @Override
    public boolean create(SysOrganizationDTO sysOrganizationDTO) {
        sysOrganizationDTO.setId(null);
        SysOrganization sysOrganization = SysOrganizationConverter.INSTANCE.dtoToPo(sysOrganizationDTO);
        Long parentId = sysOrganizationDTO.getParentId();
        this.fillDepthAndHierarchy(sysOrganization, parentId);
        return SqlHelper.retBool((Integer)((SysOrganizationMapper)this.baseMapper).insert(sysOrganization));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(SysOrganizationDTO sysOrganizationDTO) {
        SysOrganization targetParentOrganization;
        Object[] targetParentHierarchy;
        SysOrganization newSysOrganization = SysOrganizationConverter.INSTANCE.dtoToPo(sysOrganizationDTO);
        Long organizationId = newSysOrganization.getId();
        SysOrganization originSysOrganization = (SysOrganization)((SysOrganizationMapper)this.baseMapper).selectById(organizationId);
        Long targetParentId = sysOrganizationDTO.getParentId();
        if (originSysOrganization.getParentId().equals(targetParentId)) {
            return SqlHelper.retBool((Integer)((SysOrganizationMapper)this.baseMapper).updateById(newSysOrganization));
        }
        Assert.isFalse((boolean)targetParentId.equals(organizationId), (String)"\u7236\u8282\u70b9\u4e0d\u80fd\u662f\u81ea\u5df1\uff01", (Object[])new Object[0]);
        if (!GlobalConstants.TREE_ROOT_ID_LONG.equals(targetParentId) && ArrayUtil.contains((Object[])(targetParentHierarchy = (targetParentOrganization = (SysOrganization)((SysOrganizationMapper)this.baseMapper).selectById(targetParentId)).getHierarchy().split("-")), (Object)String.valueOf(organizationId))) {
            throw new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), "\u7236\u8282\u70b9\u4e0d\u80fd\u662f\u81ea\u5df1\u7684\u5b50\u8282\u70b9\uff01");
        }
        this.fillDepthAndHierarchy(newSysOrganization, targetParentId);
        OrganizationMoveChildParam param = this.getOrganizationMoveChildParam(newSysOrganization, originSysOrganization);
        ((SysOrganizationMapper)this.baseMapper).followMoveChildNode(param);
        return SqlHelper.retBool((Integer)((SysOrganizationMapper)this.baseMapper).updateById(newSysOrganization));
    }

    private OrganizationMoveChildParam getOrganizationMoveChildParam(SysOrganization newSysOrganization, SysOrganization originSysOrganization) {
        Long parentId = newSysOrganization.getId();
        String originParentHierarchy = originSysOrganization.getHierarchy();
        String targetParentHierarchy = newSysOrganization.getHierarchy();
        int depthDiff = originSysOrganization.getDepth() - newSysOrganization.getDepth();
        OrganizationMoveChildParam param = new OrganizationMoveChildParam();
        param.setParentId(parentId);
        param.setOriginParentHierarchy(originParentHierarchy);
        param.setOriginParentHierarchyLengthPlusOne(originParentHierarchy.length() + 1);
        param.setTargetParentHierarchy(targetParentHierarchy);
        param.setDepthDiff(Integer.valueOf(depthDiff));
        param.setGrandsonConditionalStatement(originParentHierarchy + "-" + parentId + "-%");
        return param;
    }

    @Override
    public List<SysOrganization> listSubOrganization(Long organizationId) {
        return ((SysOrganizationMapper)this.baseMapper).listSubOrganization(organizationId);
    }

    @Override
    public List<SysOrganization> listChildOrganization(Long organizationId) {
        return ((SysOrganizationMapper)this.baseMapper).listChildOrganization(organizationId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean revisedHierarchyAndPath() {
        List sysOrganizations = ((SysOrganizationMapper)this.baseMapper).selectList((Wrapper)Wrappers.emptyWrapper());
        Map<Long, List<SysOrganization>> map = sysOrganizations.stream().collect(Collectors.groupingBy(SysOrganization::getParentId));
        Long parentId = GlobalConstants.TREE_ROOT_ID_LONG;
        int depth = 1;
        String hierarchy = "0";
        this.updateChildHierarchyAndPath(map, parentId, depth, hierarchy);
        return true;
    }

    private void updateChildHierarchyAndPath(Map<Long, List<SysOrganization>> map, Long parentId, int depth, String hierarchy) {
        List<SysOrganization> sysOrganizations = map.get(parentId);
        if (CollUtil.isEmpty(sysOrganizations)) {
            return;
        }
        ArrayList<Long> childrenIds = new ArrayList<Long>();
        for (SysOrganization sysOrganization : sysOrganizations) {
            Long organizationId = sysOrganization.getId();
            this.updateChildHierarchyAndPath(map, organizationId, depth + 1, hierarchy + "-" + organizationId);
            childrenIds.add(organizationId);
        }
        ((SysOrganizationMapper)this.baseMapper).updateHierarchyAndPathBatch(depth, hierarchy, childrenIds);
    }

    public boolean removeById(Serializable id) {
        Long organizationId = (Long)id;
        Boolean existsChildOrganization = ((SysOrganizationMapper)this.baseMapper).existsChildOrganization(organizationId);
        if (Boolean.TRUE.equals(existsChildOrganization)) {
            throw new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), "\u8be5\u7ec4\u7ec7\u673a\u6784\u62e5\u6709\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        if (this.sysUserService.existsForOrganization(organizationId)) {
            throw new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), "\u8be5\u7ec4\u7ec7\u673a\u6784\u62e5\u6709\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        return SqlHelper.retBool((Integer)((SysOrganizationMapper)this.baseMapper).deleteById(id));
    }

    private void fillDepthAndHierarchy(SysOrganization sysOrganization, Long parentId) {
        if (GlobalConstants.TREE_ROOT_ID_LONG.equals(parentId)) {
            sysOrganization.setDepth(Integer.valueOf(1));
            sysOrganization.setHierarchy(GlobalConstants.TREE_ROOT_ID_LONG.toString());
        } else {
            SysOrganization parentSysOrganization = (SysOrganization)((SysOrganizationMapper)this.baseMapper).selectById(parentId);
            Assert.notNull((Object)parentSysOrganization, (String)"\u4e0d\u5b58\u5728\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\uff01", (Object[])new Object[0]);
            sysOrganization.setDepth(Integer.valueOf(parentSysOrganization.getDepth() + 1));
            sysOrganization.setHierarchy(parentSysOrganization.getHierarchy() + "-" + parentSysOrganization.getId());
        }
    }

    public SysOrganizationServiceImpl(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }
}

