/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.controller;

import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.system.model.entity.SysConfig;
import com.hccake.ballcat.system.model.qo.SysConfigQO;
import com.hccake.ballcat.system.model.vo.SysConfigPageVO;
import com.hccake.ballcat.system.service.SysConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/config"})
@Tag(name="\u7cfb\u7edf\u914d\u7f6e")
public class SysConfigController {
    private final SysConfigService sysConfigService;

    @GetMapping(value={"/page"})
    @PreAuthorize(value="@per.hasPermission('system:config:read')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public R<PageResult<SysConfigPageVO>> getSysConfigPage(@Validated PageParam pageParam, SysConfigQO sysConfigQO) {
        return R.ok((Object)this.sysConfigService.queryPage(pageParam, sysConfigQO));
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u7cfb\u7edf\u914d\u7f6e")
    @PostMapping
    @PreAuthorize(value="@per.hasPermission('system:config:add')")
    @Operation(summary="\u65b0\u589e\u7cfb\u7edf\u914d\u7f6e", description="\u65b0\u589e\u7cfb\u7edf\u914d\u7f6e")
    public R<Boolean> save(@RequestBody SysConfig sysConfig) {
        return R.ok((Object)this.sysConfigService.save((Object)sysConfig));
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u7cfb\u7edf\u914d\u7f6e")
    @PutMapping
    @PreAuthorize(value="@per.hasPermission('system:config:edit')")
    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u914d\u7f6e")
    public R<Boolean> updateById(@RequestBody SysConfig sysConfig) {
        return R.ok((Object)this.sysConfigService.updateByKey(sysConfig));
    }

    @DeleteOperationLogging(msg="\u5220\u9664\u7cfb\u7edf\u914d\u7f6e")
    @DeleteMapping
    @PreAuthorize(value="@per.hasPermission('system:config:del')")
    @Operation(summary="\u5220\u9664\u7cfb\u7edf\u914d\u7f6e")
    public R<Boolean> removeById(@RequestParam(value="confKey") String confKey) {
        return R.ok((Object)this.sysConfigService.removeByKey(confKey));
    }

    public SysConfigController(SysConfigService sysConfigService) {
        this.sysConfigService = sysConfigService;
    }
}

