/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.controller;

import com.hccake.ballcat.common.core.validation.group.CreateGroup;
import com.hccake.ballcat.common.core.validation.group.UpdateGroup;
import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.system.manager.SysDictManager;
import com.hccake.ballcat.system.model.dto.SysDictItemDTO;
import com.hccake.ballcat.system.model.entity.SysDict;
import com.hccake.ballcat.system.model.qo.SysDictQO;
import com.hccake.ballcat.system.model.vo.DictDataVO;
import com.hccake.ballcat.system.model.vo.SysDictItemPageVO;
import com.hccake.ballcat.system.model.vo.SysDictPageVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.validation.groups.Default;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/system/dict"})
@Tag(name="\u5b57\u5178\u8868\u7ba1\u7406")
public class SysDictController {
    private final SysDictManager sysDictManager;

    @GetMapping(value={"/data"})
    public R<List<DictDataVO>> getDictData(@RequestParam(value="dictCodes") String[] dictCodes) {
        return R.ok((Object)this.sysDictManager.queryDictDataAndHashVO(dictCodes));
    }

    @PostMapping(value={"/invalid-hash"})
    public R<List<String>> invalidDictHash(@RequestBody Map<String, String> dictHashCode) {
        return R.ok((Object)this.sysDictManager.invalidDictHash(dictHashCode));
    }

    @GetMapping(value={"/page"})
    @PreAuthorize(value="@per.hasPermission('system:dict:read')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public R<PageResult<SysDictPageVO>> getSysDictPage(@Validated PageParam pageParam, SysDictQO sysDictQO) {
        return R.ok((Object)this.sysDictManager.dictPage(pageParam, sysDictQO));
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u5b57\u5178\u8868")
    @PostMapping
    @PreAuthorize(value="@per.hasPermission('system:dict:add')")
    @Operation(summary="\u65b0\u589e\u5b57\u5178\u8868", description="\u65b0\u589e\u5b57\u5178\u8868")
    public R<Void> save(@RequestBody SysDict sysDict) {
        return this.sysDictManager.dictSave(sysDict) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u589e\u5b57\u5178\u8868\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u5b57\u5178\u8868")
    @PutMapping
    @PreAuthorize(value="@per.hasPermission('system:dict:edit')")
    @Operation(summary="\u4fee\u6539\u5b57\u5178\u8868", description="\u4fee\u6539\u5b57\u5178\u8868")
    public R<Void> updateById(@RequestBody SysDict sysDict) {
        return this.sysDictManager.updateDictById(sysDict) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u4fee\u6539\u5b57\u5178\u8868\u5931\u8d25");
    }

    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u8868")
    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@per.hasPermission('system:dict:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u8868", description="\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u8868")
    public R<Void> removeById(@PathVariable(value="id") Long id) {
        this.sysDictManager.removeDictById(id);
        return R.ok();
    }

    @GetMapping(value={"/item/page"})
    @PreAuthorize(value="@per.hasPermission('system:dict:read')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public R<PageResult<SysDictItemPageVO>> getSysDictItemPage(PageParam pageParam, @RequestParam(value="dictCode") String dictCode) {
        return R.ok((Object)this.sysDictManager.dictItemPage(pageParam, dictCode));
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u5b57\u5178\u9879")
    @PostMapping(value={"item"})
    @PreAuthorize(value="@per.hasPermission('system:dict:add')")
    @Operation(summary="\u65b0\u589e\u5b57\u5178\u9879", description="\u65b0\u589e\u5b57\u5178\u9879")
    public R<Void> saveItem(@Validated(value={Default.class, CreateGroup.class}) @RequestBody SysDictItemDTO sysDictItemDTO) {
        return this.sysDictManager.saveDictItem(sysDictItemDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u589e\u5b57\u5178\u9879\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u5b57\u5178\u9879")
    @PutMapping(value={"item"})
    @PreAuthorize(value="@per.hasPermission('system:dict:edit')")
    @Operation(summary="\u4fee\u6539\u5b57\u5178\u9879", description="\u4fee\u6539\u5b57\u5178\u9879")
    public R<Void> updateItemById(@Validated(value={Default.class, UpdateGroup.class}) @RequestBody SysDictItemDTO sysDictItemDTO) {
        return this.sysDictManager.updateDictItemById(sysDictItemDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u4fee\u6539\u5b57\u5178\u9879\u5931\u8d25");
    }

    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u9879")
    @DeleteMapping(value={"/item/{id}"})
    @PreAuthorize(value="@per.hasPermission('system:dict:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u9879", description="\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u9879")
    public R<Void> removeItemById(@PathVariable(value="id") Long id) {
        return this.sysDictManager.removeDictItemById(id) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u901a\u8fc7id\u5220\u9664\u5b57\u5178\u9879\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u901a\u8fc7id\u4fee\u6539\u5b57\u5178\u9879\u72b6\u6001")
    @PatchMapping(value={"/item/{id}"})
    @PreAuthorize(value="@per.hasPermission('system:dict:edit')")
    @Operation(summary="\u901a\u8fc7id\u4fee\u6539\u5b57\u5178\u9879\u72b6\u6001", description="\u901a\u8fc7id\u4fee\u6539\u5b57\u5178\u9879\u72b6\u6001")
    public R<Void> updateDictItemStatusById(@PathVariable(value="id") Long id, @RequestParam(value="status") Integer status) {
        this.sysDictManager.updateDictItemStatusById(id, status);
        return R.ok();
    }

    public SysDictController(SysDictManager sysDictManager) {
        this.sysDictManager = sysDictManager;
    }
}

