/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.encrypt;

import com.hy.apaas.base.core.exception.BaseException;
import com.hy.apaas.base.core.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class EncryptUtil {
    private static final String DEFAULT_KEY = "@#$%^6a7";
    private static final String KEY_ALGORITHM = "DES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";

    private EncryptUtil() {
    }

    public static String encryptMd5(String inStr) {
        return EncryptUtil.encryptMd5(inStr.getBytes());
    }

    public static String encryptMd5(byte[] bytes) {
        return DigestUtils.md5Hex((byte[])bytes);
    }

    public static String encryptFileMd5(String fileName) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(fileName);
        return EncryptUtil.encryptMd5(is);
    }

    public static String encryptMd5(InputStream is) {
        return EncryptUtil.encryptMd5(FileUtil.readByte(is));
    }

    public static String encryptFileMd5(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        return EncryptUtil.encryptMd5(out.toByteArray());
    }

    public static synchronized String encryptSha256(String inputStr) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(inputStr.getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static String decrypt(String message, String key) {
        String result = "";
        try {
            byte[] bytesrc = EncryptUtil.stringToBytes(message);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes("UTF-8"));
            cipher.init(2, (Key)secretKey, iv);
            byte[] retByte = cipher.doFinal(bytesrc);
            result = new String(retByte, "UTF-8");
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public static String decrypt(String message) {
        return EncryptUtil.decrypt(message, DEFAULT_KEY);
    }

    public static String encrypt(String message, String key) {
        byte[] retByte = new byte[]{};
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes("UTF-8"));
            cipher.init(1, (Key)secretKey, iv);
            retByte = cipher.doFinal(message.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), e.getCause());
        }
        return EncryptUtil.bytesToString(retByte);
    }

    public static String encrypt(String message) {
        return EncryptUtil.encrypt(message, DEFAULT_KEY);
    }

    public static byte[] stringToBytes(String temp) {
        byte[] digest = new byte[temp.length() / 2];
        for (int i = 0; i < digest.length; ++i) {
            String byteString = temp.substring(2 * i, 2 * i + 2);
            int byteValue = Integer.parseInt(byteString, 16);
            digest[i] = (byte)byteValue;
        }
        return digest;
    }

    public static String bytesToString(byte[] b) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String plainText = Integer.toHexString(0xFF & b[i]);
            if (plainText.length() < 2) {
                plainText = "0" + plainText;
            }
            hexString.append(plainText);
        }
        return hexString.toString();
    }
}

