/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CustomClassLoader
extends ClassLoader {
    private static ConcurrentHashMap<String, Class<?>> classes = new ConcurrentHashMap();
    private static Lock lock = new ReentrantLock();
    private String baseClassDir = "";

    public CustomClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public CustomClassLoader(String baseClassDir) {
        this();
        this.baseClassDir = baseClassDir;
    }

    public Class<?> load(String name, byte[] data, boolean resolve) {
        Class<?> klass = this.defineClass(name, data, 0, data.length);
        if (resolve) {
            this.resolveClass(klass);
        }
        classes.put(name, klass);
        return klass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String baseClassDir, String name, boolean resolve) throws ClassNotFoundException {
        Class<?> value = classes.get(name);
        if (value != null) {
            Class<?> klass = value;
            if (resolve) {
                this.resolveClass(klass);
            }
            return klass;
        }
        value = this.loadClass(name, resolve);
        if (null != value) {
            return value;
        }
        byte[] data = this.loadClassData(baseClassDir, name);
        if (data != null) {
            try {
                lock.lock();
                Class<?> cc = classes.get(name);
                if (cc != null) {
                    Class<?> clazz = cc;
                    return clazz;
                }
                Class<?> clazz = this.load(name, data, resolve);
                return clazz;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private byte[] loadClassData(String baseClassDir, String name) throws ClassNotFoundException {
        File file = this.getFile(baseClassDir, name);
        FileInputStream fis = null;
        byte[] arrData = null;
        try {
            fis = new FileInputStream(file);
            arrData = new byte[(int)file.length()];
            fis.read(arrData);
            byte[] byArray = arrData;
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File getFile(String baseClassDir, String name) throws ClassNotFoundException {
        File dir = new File(baseClassDir);
        if (!dir.exists()) {
            throw new ClassNotFoundException(baseClassDir + " \u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        String classPath = baseClassDir.replaceAll("[\\\\]", "/");
        int offset = classPath.lastIndexOf(47);
        name = name.replaceAll("[.]", "/");
        if (offset != -1 && offset < classPath.length() - 1) {
            classPath = classPath + "/";
        }
        if (!(dir = new File(classPath = classPath + name + ".class")).exists()) {
            throw new ClassNotFoundException(dir + " \u4e0d\u5b58\u5728\uff01");
        }
        return dir;
    }

    public String getBaseClassDir() {
        return this.baseClassDir;
    }

    public void setBaseClassDir(String baseClassDir) {
        this.baseClassDir = baseClassDir;
    }
}

