/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ReflectUtil;
import com.hy.apaas.base.core.exception.BaseException;
import com.hy.apaas.base.core.util.ArrayUtil;
import com.hy.apaas.base.core.util.Collections;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    public static final ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
    private static BeanUtilsBean beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());

    private BeanUtils() {
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            if (((String)o).trim().length() == 0) {
                return true;
            }
        } else {
            if (o instanceof Collection) {
                return Collections.isEmpty((Collection)o);
            }
            if (o.getClass().isArray() ? ((Object[])o).length == 0 : o instanceof Map && BeanUtils.mapEmpty(o)) {
                return true;
            }
        }
        return false;
    }

    private static boolean mapEmpty(Object o) {
        return ((Map)o).isEmpty();
    }

    public static boolean isNotEmpty(Object o) {
        return !BeanUtils.isEmpty(o);
    }

    public static boolean isNumber(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            try {
                Double.parseDouble((String)o);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static Object populateEntity(Map<String, ? extends Object> map, Object entity) throws IllegalAccessException, InvocationTargetException {
        beanUtilsBean.populate(entity, map);
        return entity;
    }

    public static boolean validClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isInherit(Class cls, Class parentClass) {
        return parentClass.isAssignableFrom(cls);
    }

    public static Object cloneBean(Object bean) {
        try {
            return beanUtilsBean.cloneBean(bean);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object cloneObject(Object obj) {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object rtn = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            in = new ObjectInputStream(byteIn);
            rtn = in.readObject();
        }
        catch (IOException e) {
            logger.error("clone object failed {}.", (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            logger.error("class not found {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return rtn;
    }

    public static void copyNotNullProperties1(Object dest, Object orig) {
        if (dest == null) {
            logger.error("No destination bean specified");
            return;
        }
        if (orig == null) {
            logger.error("No origin bean specified");
            return;
        }
        try {
            if (orig instanceof DynaBean) {
                DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
                for (int i = 0; i < origDescriptors.length; ++i) {
                    String name = origDescriptors[i].getName();
                    if (!beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    Object value = ((DynaBean)orig).get(name);
                    beanUtilsBean.copyProperty(dest, name, value);
                }
            } else if (orig instanceof Map) {
                for (Map.Entry entry : ((Map)orig).entrySet()) {
                    String name = (String)entry.getKey();
                    if (!beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    beanUtilsBean.copyProperty(dest, name, entry.getValue());
                }
            } else {
                PropertyDescriptor[] origDescriptors = beanUtilsBean.getPropertyUtils().getPropertyDescriptors(orig);
                for (int i = 0; i < origDescriptors.length; ++i) {
                    Object value;
                    String name = origDescriptors[i].getName();
                    if ("class".equals(name) || !beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name) || (value = beanUtilsBean.getPropertyUtils().getSimpleProperty(orig, name)) == null) continue;
                    beanUtilsBean.copyProperty(dest, name, value);
                }
            }
        }
        catch (Exception ex) {
            BeanUtils.handleReflectionException(ex);
        }
    }

    public static void copyNotNullProperties(Object dest, Object orig) {
        if (dest == null) {
            logger.error("No destination bean specified");
            return;
        }
        if (orig == null) {
            logger.error("No origin bean specified");
            return;
        }
        try {
            if (orig instanceof DynaBean) {
                DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
                for (int i = 0; i < origDescriptors.length; ++i) {
                    String name = origDescriptors[i].getName();
                    if (!beanUtilsBean.getPropertyUtils().isReadable(orig, name) || !beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    Object value = ((DynaBean)orig).get(name);
                    beanUtilsBean.copyProperty(dest, name, value);
                }
            } else if (orig instanceof Map) {
                for (Map.Entry entry : ((Map)orig).entrySet()) {
                    String name = (String)entry.getKey();
                    if (!beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) continue;
                    beanUtilsBean.copyProperty(dest, name, entry.getValue());
                }
            } else {
                PropertyDescriptor[] origDescriptors = beanUtilsBean.getPropertyUtils().getPropertyDescriptors(orig);
                for (int i = 0; i < origDescriptors.length; ++i) {
                    Object value;
                    String name = origDescriptors[i].getName();
                    if ("class".equals(name)) continue;
                    if (beanUtilsBean.getPropertyUtils().isReadable(orig, name) && beanUtilsBean.getPropertyUtils().isWriteable(dest, name)) {
                        value = beanUtilsBean.getPropertyUtils().getSimpleProperty(orig, name);
                        if (value == null) continue;
                        if (value instanceof Collection) {
                            beanUtilsBean.copyProperty(dest, name, Collections.deepCopy((Collection)value));
                            continue;
                        }
                        if (value instanceof Map) {
                            HashMap mapValue = new HashMap();
                            BeanUtils.copyNotNullProperties(mapValue, value);
                            beanUtilsBean.copyProperty(dest, name, mapValue);
                            continue;
                        }
                        if (value instanceof Function || BeanUtils.isBaseJavaType(value) || EnumUtil.isEnum((Object)value)) {
                            beanUtilsBean.copyProperty(dest, name, value);
                            continue;
                        }
                        if (value instanceof String) {
                            beanUtilsBean.copyProperty(dest, name, (Object)new String(value.toString()));
                            continue;
                        }
                        if (value instanceof Object[]) {
                            beanUtilsBean.copyProperty(dest, name, (Object)ArrayUtil.deepCopy((Object[])value));
                            continue;
                        }
                        Object v = BeanUtils.copyNotNullProperties(value.getClass(), value);
                        beanUtilsBean.copyProperty(dest, name, v);
                        continue;
                    }
                    value = ReflectUtil.getFieldValue((Object)orig, (String)name);
                    if (value != null && value instanceof Object[]) {
                        ReflectUtil.setFieldValue((Object)dest, (String)name, (Object)ArrayUtil.deepCopy((Object[])value));
                        continue;
                    }
                    if (value == null || !BeanUtils.isBaseJavaTypeArray(value)) continue;
                    throw new BaseException("\u6682\u4e0d\u652f\u6301\u57fa\u672c\u7c7b\u578b\u6570\u7ec4\u6df1\u5ea6\u590d\u5236\uff0c\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b\u6570\u7ec4\uff01");
                }
            }
        }
        catch (Exception ex) {
            BeanUtils.handleReflectionException(ex);
        }
    }

    private static boolean isBaseJavaType(Object value) {
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        if (value instanceof Byte) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        return value instanceof Boolean;
    }

    private static boolean isBaseJavaTypeArray(Object value) {
        if (value instanceof long[]) {
            return true;
        }
        if (value instanceof int[]) {
            return true;
        }
        if (value instanceof short[]) {
            return true;
        }
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof double[]) {
            return true;
        }
        if (value instanceof float[]) {
            return true;
        }
        if (value instanceof char[]) {
            return true;
        }
        return value instanceof boolean[];
    }

    public static <T> T copyProperties(Class<T> destClass, Object orig) {
        T target = null;
        try {
            target = destClass.newInstance();
            BeanUtils.copyProperties(target, orig);
            return target;
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static <T> T copyNotNullProperties(Class<T> destClass, Object orig) {
        T target = null;
        try {
            target = destClass.newInstance();
            BeanUtils.copyNotNullProperties(target, orig);
            return target;
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            beanUtilsBean.copyProperties(dest, orig);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    public static void copyProperty(Object bean, String name, Object value) {
        try {
            beanUtilsBean.copyProperty(bean, name, value);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    public static <T> T copy(T src) {
        return BeanUtils.jdkCopy(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T jdkCopy(T src) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        ByteArrayInputStream byteIn = null;
        ObjectInputStream in = null;
        Object dest = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            in = new ObjectInputStream(byteIn);
            dest = in.readObject();
        }
        catch (IOException e) {
            BeanUtils.handleReflectionException(e);
        }
        catch (ClassNotFoundException e) {
            BeanUtils.handleReflectionException(e);
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return (T)dest;
    }

    public static Map<?, ?> describe(Object bean) {
        try {
            return beanUtilsBean.describe(bean);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String[] getArrayProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getArrayProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return new String[0];
        }
    }

    public static ConvertUtilsBean getConvertUtils() {
        return beanUtilsBean.getConvertUtils();
    }

    public static String getIndexedProperty(Object bean, String name, int index) {
        try {
            return beanUtilsBean.getIndexedProperty(bean, name, index);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getIndexedProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getIndexedProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getMappedProperty(Object bean, String name, String key) {
        try {
            return beanUtilsBean.getMappedProperty(bean, name, key);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getMappedProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getMappedProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getNestedProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getNestedProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static PropertyUtilsBean getPropertyUtils() {
        try {
            return beanUtilsBean.getPropertyUtils();
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getSimpleProperty(Object bean, String name) {
        try {
            return beanUtilsBean.getSimpleProperty(bean, name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static void populate(Object bean, Map<String, ? extends Object> properties) {
        try {
            beanUtilsBean.populate(bean, properties);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            beanUtilsBean.setProperty(bean, name, value);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    private static void handleReflectionException(Exception e) {
        throw new BaseException(e);
    }

    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = BeanUtils.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Object convertByActType(String typeName, String value) {
        Object o = null;
        o = typeName.equals("int") ? Integer.valueOf(Integer.parseInt(value)) : (typeName.equals("short") ? Short.valueOf(Short.parseShort(value)) : (typeName.equals("long") ? Long.valueOf(Long.parseLong(value)) : (typeName.equals("float") ? Float.valueOf(Float.parseFloat(value)) : (typeName.equals("double") ? Double.valueOf(Double.parseDouble(value)) : (typeName.equals("boolean") ? Boolean.valueOf(Boolean.parseBoolean(value)) : (typeName.equals("java.lang.String") ? value : value))))));
        return o;
    }

    public static Field getField(Class thisClass, String fieldName) throws NoSuchFieldException {
        if (fieldName == null) {
            throw new NoSuchFieldException("Error field !");
        }
        return thisClass.getDeclaredField(fieldName);
    }

    public static void mergeObject(Object srcObj, Object desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Field[] fs1 = srcObj.getClass().getDeclaredFields();
        Field[] fs2 = desObj.getClass().getDeclaredFields();
        for (int i = 0; i < fs1.length; ++i) {
            try {
                fs1[i].setAccessible(true);
                Object value = fs1[i].get(srcObj);
                fs1[i].setAccessible(false);
                if (null == value) continue;
                fs2[i].setAccessible(true);
                fs2[i].set(desObj, value);
                fs2[i].setAccessible(false);
                continue;
            }
            catch (Exception e) {
                logger.error("mergeObject" + e.getMessage());
            }
        }
    }

    static {
        convertUtilsBean.register((Converter)new DateConverter(), Date.class);
        convertUtilsBean.register((Converter)new LongConverter(null), Long.class);
    }
}

