/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.exception.spi.SpiExceptionService;
import com.hy.apaas.base.core.util.SpiServiceUtil;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static String getStackTraceAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static boolean isCausedBy(Exception ex, Class<? extends Exception> ... causeExceptionClasses) {
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static String analysisCause(Exception exception) {
        if (exception.getCause() == null) {
            return ExceptionUtil.analysisException(exception);
        }
        return ExceptionUtil.analysisCause(exception.getCause());
    }

    private static String analysisException(Exception exception) {
        if (null == exception) {
            return "";
        }
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        exceptionClassName = exception.getClass().getName();
        String message = null;
        ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
        for (SpiExceptionService spiExceptionService2 : loader) {
            if (!exceptionClassName.equals(spiExceptionService2.getClassName()) || !StringUtil.isNotBlank((CharSequence)(message = spiExceptionService2.analysis(exception)))) continue;
            return message;
        }
        return exception.getMessage();
    }

    public static String analysisCause(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        ArrayList<Throwable> throwableStacks = new ArrayList<Throwable>();
        ExceptionUtil.createThrowableStacks(throwable, throwableStacks);
        Collections.reverse(throwableStacks);
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        String message = null;
        for (Throwable throwable0 : throwableStacks) {
            exceptionClassName = throwable0.getClass().getName();
            ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
            for (SpiExceptionService spiExceptionService2 : loader) {
                if (!exceptionClassName.equals(spiExceptionService2.getClassName()) || !StringUtil.isNotBlank((CharSequence)(message = spiExceptionService2.analysis(throwable0)))) continue;
                return message;
            }
        }
        return throwable.getMessage();
    }

    private static void createThrowableStacks(Throwable throwable, List<Throwable> throwableStacks) {
        if (null == throwable) {
            return;
        }
        throwableStacks.add(throwable);
        Throwable t = throwable.getCause();
        if (t == null) {
            return;
        }
        ExceptionUtil.createThrowableStacks(throwable.getCause(), throwableStacks);
    }

    public static String analysisDeepCause(Exception exception) {
        if (exception.getCause() == null) {
            return ExceptionUtil.analysisDeepException(exception);
        }
        return ExceptionUtil.analysisDeepCause(exception.getCause());
    }

    private static String analysisDeepException(Exception exception) {
        if (null == exception) {
            return "";
        }
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        exceptionClassName = exception.getClass().getName();
        String message = null;
        ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
        for (SpiExceptionService spiExceptionService2 : loader) {
            if (!exceptionClassName.equals(spiExceptionService2.getClassName()) || !StringUtil.isNotBlank((CharSequence)(message = spiExceptionService2.analysis(exception)))) continue;
            return message;
        }
        Throwable throwable = ExceptionUtil.getDeepException(exception);
        return ExceptionUtil.analysisCause(throwable);
    }

    public static String analysisDeepCause(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        throwable = ExceptionUtil.getDeepThrowable(throwable);
        SpiExceptionService spiExceptionService2 = null;
        String exceptionClassName = null;
        String message = null;
        exceptionClassName = throwable.getClass().getName();
        ServiceLoader<SpiExceptionService> loader = SpiServiceUtil.loadAll(SpiExceptionService.class);
        for (SpiExceptionService spiExceptionService2 : loader) {
            if (!exceptionClassName.equals(spiExceptionService2.getClassName()) || !StringUtil.isNotBlank((CharSequence)(message = spiExceptionService2.analysis(throwable)))) continue;
            return message;
        }
        return throwable.getMessage();
    }

    private static Throwable getDeepException(Exception exception) {
        if (null == exception) {
            return null;
        }
        Throwable t = exception.getCause();
        return ExceptionUtil.getDeepThrowable(t);
    }

    private static Throwable getDeepThrowable(Throwable throwable) {
        if (null == throwable) {
            return null;
        }
        Throwable t = throwable.getCause();
        if (t == null) {
            return throwable;
        }
        return ExceptionUtil.getDeepThrowable(t);
    }
}

