/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.util.BeanUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LogUtil {
    private static final LogUtil LOG_UTIL = new LogUtil();
    public static final String LOGGER_PLATFORM = "pltform";
    public static final String LOGGER_BUSINESS = "business";
    public static final String LOGGER_EXCEPTION = "exception";
    public static final String LOGGER_DB = "db";

    private LogUtil() {
    }

    public static LogUtil getInstance() {
        return LOG_UTIL;
    }

    public static Logger getLogger(String loggerName) {
        return LoggerFactory.getLogger((String)loggerName);
    }

    public static Logger getBussinessLogger() {
        return LoggerFactory.getLogger((String)LOGGER_BUSINESS);
    }

    public static Logger getPlatformLogger() {
        return LoggerFactory.getLogger((String)LOGGER_PLATFORM);
    }

    public static Logger getDBLogger() {
        return LoggerFactory.getLogger((String)LOGGER_DB);
    }

    public static Logger getExceptionLogger() {
        return LoggerFactory.getLogger((String)LOGGER_EXCEPTION);
    }

    public static void trace(Logger logger, String format, Object ... args) {
        if (logger.isTraceEnabled()) {
            logger.trace(format, args);
        }
    }

    @SafeVarargs
    public static void trace(Logger logger, String format, Supplier<Object> ... suppliers) {
        Object[] args = LogUtil.transferArgs(suppliers);
        LogUtil.trace(logger, format, args);
    }

    public static void trace(Logger logger, Supplier<Object> supplier) {
        if (logger.isTraceEnabled()) {
            logger.trace(Objects.toString(supplier.get()));
        }
    }

    public static void trace(Logger logger, Map<String, String> outContextMap, String format, Object ... args) {
        LogUtil.setMDC(outContextMap);
        LogUtil.trace(logger, format, args);
    }

    @SafeVarargs
    public static void trace(Logger logger, Map<String, String> outContextMap, String format, Supplier<Object> ... suppliers) {
        LogUtil.setMDC(outContextMap);
        LogUtil.trace(logger, format, suppliers);
    }

    public static void trace(Logger logger, Map<String, String> outContextMap, Supplier<Object> supplier) {
        LogUtil.setMDC(outContextMap);
        LogUtil.trace(logger, supplier);
    }

    public static void debug(Logger logger, String format, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, args);
        }
    }

    @SafeVarargs
    public static void debug(Logger logger, String format, Supplier<Object> ... suppliers) {
        Object[] args = LogUtil.transferArgs(suppliers);
        LogUtil.debug(logger, format, args);
    }

    public static void debug(Logger logger, Supplier<Object> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(Objects.toString(supplier.get()));
        }
    }

    public static void debug(Logger logger, Map<String, String> outContextMap, String format, Object ... args) {
        LogUtil.setMDC(outContextMap);
        LogUtil.debug(logger, format, args);
    }

    @SafeVarargs
    public static void debug(Logger logger, Map<String, String> outContextMap, String format, Supplier<Object> ... suppliers) {
        LogUtil.setMDC(outContextMap);
        LogUtil.debug(logger, format, suppliers);
    }

    public static void debug(Logger logger, Map<String, String> outContextMap, Supplier<Object> supplier) {
        LogUtil.setMDC(outContextMap);
        LogUtil.debug(logger, supplier);
    }

    public static void info(Logger logger, String format, Object ... args) {
        if (logger.isInfoEnabled()) {
            logger.info(format, args);
        }
    }

    @SafeVarargs
    public static void info(Logger logger, String format, Supplier<Object> ... suppliers) {
        Object[] args = LogUtil.transferArgs(suppliers);
        LogUtil.info(logger, format, args);
    }

    public static void info(Logger logger, Supplier<Object> supplier) {
        if (logger.isInfoEnabled()) {
            logger.info(Objects.toString(supplier.get()));
        }
    }

    public static void info(Logger logger, Map<String, String> outContextMap, String format, Object ... args) {
        LogUtil.setMDC(outContextMap);
        LogUtil.info(logger, format, args);
    }

    @SafeVarargs
    public static void info(Logger logger, Map<String, String> outContextMap, String format, Supplier<Object> ... suppliers) {
        LogUtil.setMDC(outContextMap);
        LogUtil.info(logger, format, suppliers);
    }

    public static void info(Logger logger, Map<String, String> outContextMap, Supplier<Object> supplier) {
        LogUtil.setMDC(outContextMap);
        LogUtil.info(logger, supplier);
    }

    public static void warn(Logger logger, String format, Object ... args) {
        if (logger.isWarnEnabled()) {
            logger.warn(format, args);
        }
    }

    @SafeVarargs
    public static void warn(Logger logger, String format, Supplier<Object> ... suppliers) {
        Object[] args = LogUtil.transferArgs(suppliers);
        LogUtil.warn(logger, format, args);
    }

    public static void warn(Logger logger, Supplier<Object> supplier) {
        if (logger.isWarnEnabled()) {
            logger.warn(Objects.toString(supplier.get()));
        }
    }

    public static void warn(Logger logger, Map<String, String> outContextMap, String format, Object ... args) {
        LogUtil.setMDC(outContextMap);
        LogUtil.warn(logger, format, args);
    }

    @SafeVarargs
    public static void warn(Logger logger, Map<String, String> outContextMap, String format, Supplier<Object> ... suppliers) {
        LogUtil.setMDC(outContextMap);
        LogUtil.warn(logger, format, suppliers);
    }

    public static void warn(Logger logger, Map<String, String> outContextMap, Supplier<Object> supplier) {
        LogUtil.setMDC(outContextMap);
        LogUtil.warn(logger, supplier);
    }

    public static void error(Logger logger, String format, Object ... args) {
        if (logger.isErrorEnabled()) {
            logger.error(format, args);
        }
    }

    @SafeVarargs
    public static void error(Logger logger, String format, Supplier<Object> ... suppliers) {
        Object[] args = LogUtil.transferArgs(suppliers);
        LogUtil.error(logger, format, args);
    }

    public static void error(Logger logger, Supplier<Object> supplier) {
        if (logger.isErrorEnabled()) {
            logger.error(Objects.toString(supplier.get()));
        }
    }

    public static void error(Logger logger, Throwable e, String format, Object ... args) {
        if (logger.isErrorEnabled()) {
            logger.error(format, (Object)args, (Object)e);
        }
    }

    @SafeVarargs
    public static void error(Logger logger, Throwable e, String format, Supplier<Object> ... suppliers) {
        Object[] args = LogUtil.transferArgs(suppliers);
        LogUtil.error(logger, e, format, args);
    }

    public static void error(Logger logger, Throwable e, Supplier<Object> supplier) {
        if (logger.isErrorEnabled()) {
            logger.error(Objects.toString(supplier.get()), e);
        }
    }

    public static void error(Logger logger, Map<String, String> outContextMap, String format, Object ... args) {
        LogUtil.setMDC(outContextMap);
        LogUtil.error(logger, format, args);
    }

    @SafeVarargs
    public static void error(Logger logger, Map<String, String> outContextMap, String format, Supplier<Object> ... suppliers) {
        LogUtil.setMDC(outContextMap);
        LogUtil.error(logger, format, suppliers);
    }

    public static void error(Logger logger, Map<String, String> outContextMap, Supplier<Object> supplier) {
        LogUtil.setMDC(outContextMap);
        LogUtil.error(logger, supplier);
    }

    public static void error(Logger logger, Throwable e, Map<String, String> outContextMap, String format, Object ... args) {
        LogUtil.setMDC(outContextMap);
        LogUtil.error(logger, e, format, args);
    }

    @SafeVarargs
    public static void error(Logger logger, Throwable e, Map<String, String> outContextMap, String format, Supplier<Object> ... suppliers) {
        LogUtil.setMDC(outContextMap);
        LogUtil.error(logger, e, format, suppliers);
    }

    public static void error(Logger logger, Throwable e, Map<String, String> outContextMap, Supplier<Object> supplier) {
        LogUtil.setMDC(outContextMap);
        LogUtil.error(logger, e, supplier);
    }

    public static Map<String, String> getMDC() {
        return MDC.getCopyOfContextMap();
    }

    public static void setMDC(Map<String, String> outContextMap) {
        Map contextMap = MDC.getCopyOfContextMap();
        contextMap = Optional.ofNullable(contextMap).orElse(new HashMap());
        contextMap.put("threadid", Thread.currentThread().getId() + "");
        if (BeanUtils.isNotEmpty(outContextMap)) {
            contextMap.putAll(outContextMap);
        }
        MDC.setContextMap((Map)contextMap);
    }

    @SafeVarargs
    private static Object[] transferArgs(Supplier<Object> ... suppliers) {
        Object[] args = new Object[suppliers.length];
        for (int i = 0; i < suppliers.length; ++i) {
            args[i] = suppliers[i].get();
        }
        return args;
    }
}

