/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.context.ThreadContext;
import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.EnvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadContextUtil.class);
    private static ThreadContextUtil contextUtil;
    private ThreadContext threadContext;

    public ThreadContextUtil init() {
        this.threadContext = EnvUtil.getBean(ThreadContext.class);
        if (BeanUtils.isEmpty(this.threadContext) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("ThreadContext is null.");
        }
        contextUtil = this;
        return this;
    }

    public void setCurrentContext(ThreadContext _currentContext) {
        this.threadContext = _currentContext;
        contextUtil = this;
    }

    public static Object getProperty(String context, String key) {
        return ThreadContextUtil.contextUtil.threadContext.getProperty(context, key);
    }

    public static void addProperty(String context, String key, Object val) {
        ThreadContextUtil.contextUtil.threadContext.addProperty(context, key, val);
    }

    public static void cleanProperty(String context, String key) {
        ThreadContextUtil.contextUtil.threadContext.cleanProperty(context, key);
    }

    public static Object getProperty(String key) {
        return ThreadContextUtil.contextUtil.threadContext.getProperty(key);
    }

    public static void addProperty(String key, Object val) {
        ThreadContextUtil.contextUtil.threadContext.addProperty(key, val);
    }

    public static void cleanProperty(String key) {
        ThreadContextUtil.contextUtil.threadContext.cleanProperty(key);
    }

    public static void clean(String context) {
        ThreadContextUtil.contextUtil.threadContext.clean(context);
    }

    public static void cleanAll() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("current context Thread ID: " + Thread.currentThread().getId());
        }
        ThreadContextUtil.contextUtil.threadContext.cleanAll();
    }
}

