/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.hy.apaas.base.core.util.string.StringUtil;
import com.hy.apaas.base.core.util.time.DateUtil;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;

public class DateSerializer
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private String format = "yyyy-MM-dd HH:mm:ss.SSS";
    private String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.sssZZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyyMMddHHmmssSSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyyMM", "yyyyMMdd", "HH:mm:ss", "HH:mm"};

    public DateSerializer() {
    }

    public DateSerializer(String format) {
        if (StringUtil.isNotBlank((CharSequence)format)) {
            this.format = format;
        }
    }

    public Date deserialize(JsonElement json, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        for (String format : this.formats) {
            try {
                return DateUtil.parseDate((String)json.getAsJsonPrimitive().getAsString(), (String[])new String[]{format});
            }
            catch (ParseException parseException) {
            }
        }
        throw new JsonParseException("Unparseable date: \"" + json.getAsJsonPrimitive().getAsString() + "\". Supported formats: " + Arrays.toString(this.formats));
    }

    public JsonElement serialize(Date arg0, Type arg1, JsonSerializationContext arg2) {
        String s = DateFormatUtils.format((Date)arg0, (String)this.format);
        return new JsonPrimitive(s);
    }
}

