/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.reflect.Field;

public class SuperclassExclusionStrategy
implements ExclusionStrategy {
    public boolean shouldSkipField(FieldAttributes f) {
        String fieldName = f.getName();
        Class theClass = f.getDeclaringClass();
        return this.isFieldInSuperclass(theClass, fieldName);
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }

    private boolean isFieldInSuperclass(Class<?> subclass, String fieldName) {
        Field field = null;
        for (Class<?> superclass = subclass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            field = this.getField(superclass, fieldName);
            if (field == null) continue;
            return true;
        }
        return false;
    }

    private Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

