/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampSerializer
implements JsonSerializer<Timestamp>,
JsonDeserializer<Timestamp> {
    private String format = "yyyy-MM-dd HH:mm:ss";

    public TimestampSerializer() {
    }

    public TimestampSerializer(String format) {
        if (StringUtil.isNotBlank((CharSequence)format)) {
            this.format = format;
        }
    }

    public JsonElement serialize(Timestamp src, Type arg1, JsonSerializationContext arg2) {
        SimpleDateFormat df = new SimpleDateFormat(this.format);
        String dateFormatAsString = df.format(new Date(src.getTime()));
        return new JsonPrimitive(dateFormatAsString);
    }

    public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(this.format);
            Date date = df.parse(json.getAsString());
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

