/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.json;

import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.JacksonUtil;
import com.hy.apaas.base.core.util.json.DateMorpherExt;
import com.hy.apaas.base.core.util.json.JsonDateValueProcessor;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);

    private JsonUtil() {
    }

    public static boolean isEmpty(Object o) {
        if (BeanUtils.isEmpty(o)) {
            return true;
        }
        if (o instanceof JSONObject) {
            return ((JSONObject)o).isNullObject();
        }
        if (o instanceof JSONArray) {
            return ((JSONArray)o).isEmpty();
        }
        if (o instanceof JSONNull) {
            return true;
        }
        if (JSONUtils.isNull((Object)o)) {
            return true;
        }
        return JSONNull.getInstance().equals(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !JsonUtil.isEmpty(o);
    }

    public static boolean isJson(String jsonStr) {
        return JsonUtil.isJsonObject(jsonStr) || JsonUtil.isJsonArray(jsonStr);
    }

    public static void assert0(String jsonStr, String message) {
        boolean isJson;
        boolean bl = isJson = JsonUtil.isJsonObject(jsonStr) || JsonUtil.isJsonArray(jsonStr);
        if (!isJson) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNotJson(String jsonStr) {
        return !JsonUtil.isJson(jsonStr);
    }

    public static boolean isJsonObject(Object jsonStr) {
        if (JsonUtil.isEmpty(jsonStr)) {
            return false;
        }
        return JacksonUtil.isJsonObject(jsonStr.toString());
    }

    public static boolean isNotJsonObject(Object jsonStr) {
        return !JsonUtil.isJsonObject(jsonStr);
    }

    public static boolean isJsonArray(Object jsonStr) {
        if (JsonUtil.isEmpty(jsonStr)) {
            return false;
        }
        return JacksonUtil.isJsonArray(jsonStr.toString());
    }

    public static boolean isNotJsonArray(Object jsonStr) {
        return !JsonUtil.isJsonArray(jsonStr);
    }

    public static Object getDTO(String jsonStr, Class clazz) {
        return JsonUtil.getDTO(jsonStr, clazz, "");
    }

    public static Object getDTO(String jsonStr, Class clazz, String dateFormat) {
        JSONObject jsonObject = null;
        try {
            if (StringUtil.isEmpty((CharSequence)dateFormat)) {
                JsonUtil.setDataFormat2JAVA();
            } else {
                JsonUtil.setDataFormat2JAVA(dateFormat);
            }
            jsonObject = JSONObject.fromObject(JacksonUtil.toMap(jsonStr));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return JSONObject.toBean((JSONObject)jsonObject, (Class)clazz);
    }

    public static JSONObject fromJsonString(String data) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.fromObject(JacksonUtil.toMap(data));
        }
        catch (Exception e) {
            try {
                data = data.replaceAll("\\\\", "");
                jsonObject = JSONObject.fromObject(JacksonUtil.toMap(data));
            }
            catch (Exception e1) {
                logger.warn(e1.getMessage(), (Throwable)e1);
            }
        }
        return jsonObject;
    }

    public static <T> T getDTO2(String jsonStr, Class<T> clazz) {
        return JsonUtil.getDTO2(jsonStr, clazz, "");
    }

    public static <T> T getDTO2(String jsonStr, Class<T> clazz, String dateFormat) {
        JSONObject jsonObject = null;
        try {
            if (StringUtil.isEmpty((CharSequence)dateFormat)) {
                JsonUtil.setDataFormat2JAVA();
            } else {
                JsonUtil.setDataFormat2JAVA(dateFormat);
            }
            jsonObject = JSONObject.fromObject(JacksonUtil.toMap(jsonStr));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return (T)JSONObject.toBean((JSONObject)jsonObject, clazz);
    }

    public static Object getDTO(String jsonString, Class clazz, Map map) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject(JacksonUtil.toMap(jsonString));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return JSONObject.toBean((JSONObject)jsonObject, (Class)clazz, (Map)map);
    }

    public static <T> T getDTO2(String jsonString, Class<T> clazz, Map map) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject(JacksonUtil.toMap(jsonString));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return (T)JSONObject.toBean((JSONObject)jsonObject, clazz, (Map)map);
    }

    public static Object[] getDTOArray(String jsonString, Class clazz) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject(JacksonUtil.getDTOList(jsonString, clazz));
        Object[] obj = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            obj[i] = JSONObject.toBean((JSONObject)jsonObject, (Class)clazz);
        }
        return obj;
    }

    public static Object[] getDTOArray(String jsonString, Class clazz, Map map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        Object[] obj = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            obj[i] = JSONObject.toBean((JSONObject)jsonObject, (Class)clazz, (Map)map);
        }
        return obj;
    }

    public static List getDTOList(String jsonString) {
        ArrayList list = new ArrayList();
        if (JsonUtil.isEmpty(jsonString)) {
            return list;
        }
        return JacksonUtil.getDTOList(jsonString, Map.class);
    }

    public static List getDTOList(String jsonString, Class clazz) {
        ArrayList list = new ArrayList();
        if (JsonUtil.isEmpty(jsonString)) {
            return list;
        }
        return JacksonUtil.getDTOList(jsonString, clazz);
    }

    public static List getDTOList(String jsonString, Class clazz, Map map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject(JacksonUtil.getDTOList(jsonString));
        ArrayList<Object> list = new ArrayList<Object>();
        for (JSONObject jsonObject : array) {
            list.add(JSONObject.toBean((JSONObject)jsonObject, (Class)clazz, (Map)map));
        }
        return list;
    }

    public static <T> List<T> getDTOList2(String jsonString, Class<T> clazz, Map map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject(JacksonUtil.getDTOList(jsonString));
        ArrayList<T> list = new ArrayList<T>();
        for (JSONObject jsonObject : array) {
            list.add(JsonUtil.getDTO2(jsonObject.toString(), clazz, map));
        }
        return list;
    }

    public static Map<String, Object> getMapFromJson(String jsonString) {
        return JacksonUtil.toMap(jsonString);
    }

    public static Map getMapFromJson(String jsonString, Class clazz) {
        HashMap<String, List> map = new HashMap<String, List>();
        if (JsonUtil.isEmpty(jsonString)) {
            return map;
        }
        JsonUtil.setDataFormat2JAVA();
        JSONObject jsonObject = JSONObject.fromObject(JacksonUtil.toMap(jsonString));
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (jsonObject.get(key) == null) continue;
            List list = JsonUtil.getDTOList(jsonObject.get(key).toString(), clazz);
            map.put(key, list);
        }
        return map;
    }

    public static Object[] getObjectArrayFromJson(String jsonString) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return jsonArray.toArray();
    }

    public static String getJSONString(Object o, String dateFormat, String defaultVal) {
        String jsonString = null;
        JsonConfig jsonConfig = new JsonConfig();
        JsonDateValueProcessor jsonDateValueProcessor = StringUtil.isNotEmpty((CharSequence)dateFormat) ? new JsonDateValueProcessor(dateFormat) : new JsonDateValueProcessor();
        jsonConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)jsonDateValueProcessor);
        if (JsonUtil.isEmpty(o)) {
            return defaultVal;
        }
        jsonString = o instanceof Collection || o instanceof Object[] ? JSONArray.fromObject((Object)o, (JsonConfig)jsonConfig).toString() : JSONObject.fromObject((Object)o, (JsonConfig)jsonConfig).toString();
        return jsonString == null ? defaultVal : jsonString;
    }

    public static String getJSONString(Object o, String defaultVal) {
        return JsonUtil.getJSONString(o, null, defaultVal);
    }

    public static String getJSONStringByDateFormat(Object o, String dateFormat) {
        return JsonUtil.getJSONString(o, dateFormat, "{}");
    }

    public static String getJSONString(Object jsonObj) {
        return JsonUtil.getJSONString(jsonObj, null, "{}");
    }

    public static void setDataFormat2JAVA(String[] dateFormat) {
        JSONUtils.getMorpherRegistry().registerMorpher((Morpher)new DateMorpherExt(dateFormat, (Date)null));
    }

    private static void setDataFormat2JAVA(String dateFormat) {
        JsonUtil.setDataFormat2JAVA(new String[]{dateFormat});
    }

    private static void setDataFormat2JAVA() {
        JsonUtil.setDataFormat2JAVA(new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"});
    }

    public static String getString(JSONObject obj, String key, String defaultValue) {
        if (BeanUtils.isEmpty(obj)) {
            return null;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        return obj.getString(key);
    }

    public static String getString(JSONObject obj, String key) {
        return JsonUtil.getString(obj, key, "");
    }

    public static long getLong(JSONObject obj, String key) {
        return JsonUtil.getLong(obj, key, 0L);
    }

    public static long getLong(JSONObject obj, String key, long defaultValue) {
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        try {
            return obj.getLong(key);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static int getInt(JSONObject obj, String key) {
        return JsonUtil.getInt(obj, key, 0);
    }

    public static int getInt(JSONObject obj, String key, int defaultValue) {
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        try {
            return obj.getInt(key);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBool(JSONObject o, String key) {
        return JsonUtil.getBool(o, key, false);
    }

    public static boolean getBool(JSONObject o, String key, boolean defaultValue) {
        if (!o.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(o.get(key))) {
            return defaultValue;
        }
        try {
            Object obj = o.get(key);
            if (obj != null) {
                if (obj.equals(Boolean.FALSE) || obj instanceof String && ((String)obj).equalsIgnoreCase("N") || obj instanceof Integer && (Integer)obj == 0) {
                    return false;
                }
                if (obj.equals(Boolean.TRUE) || obj instanceof String && ((String)obj).equalsIgnoreCase("Y") || obj instanceof Integer && (Integer)obj == 1) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return defaultValue;
    }

    public static boolean getBoolean(JSONObject o, String key) {
        return JsonUtil.getBoolean(o, key, false);
    }

    public static boolean getBoolean(JSONObject o, String key, boolean defaultValue) {
        if (!o.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(o.get(key))) {
            return defaultValue;
        }
        try {
            return o.getBoolean(key);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static char getChar(JSONObject obj, String key) {
        return JsonUtil.getChar(obj, key, 'Y');
    }

    public static char getChar(JSONObject obj, String key, char defaultValue) {
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        String v = obj.getString(key);
        char[] c = v.toCharArray();
        if (c.length == 0) {
            return defaultValue;
        }
        return v.toCharArray()[0];
    }

    public static float getFloat(JSONObject obj, String key) {
        return JsonUtil.getFloat(obj, key, 0.0f);
    }

    public static float getFloat(JSONObject obj, String key, float defaultValue) {
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        Object v = obj.get(key);
        return Float.valueOf(v.toString()).floatValue();
    }

    public static double getDouble(JSONObject obj, String key) {
        return JsonUtil.getDouble(obj, key, 0.0);
    }

    public static double getDouble(JSONObject obj, String key, double defaultValue) {
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (JsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        Object v = obj.get(key);
        return Double.valueOf(v.toString());
    }

    public static JSONArray getJSONArray(JSONObject obj, String key) {
        Object json = obj.get(key);
        if (JsonUtil.isEmpty(json)) {
            return null;
        }
        return (JSONArray)json;
    }

    public static JSONObject getJSONobject(JSONObject obj, String key) {
        Object json = obj.get(key);
        if (JsonUtil.isEmpty(json)) {
            return null;
        }
        return (JSONObject)json;
    }
}

