/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.string;

import com.hy.apaas.base.core.util.string.StringValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormater {
    private static final String CLASS_KEY = "class";
    private static final String VALUE_KEY = "value";

    private StringFormater() {
    }

    public static String format(String contentWithNumberPlaceHolder, Object ... numberReplaceParams) {
        for (int i = 0; i < numberReplaceParams.length; ++i) {
            contentWithNumberPlaceHolder = contentWithNumberPlaceHolder.replace("${" + i + "}", numberReplaceParams[i].toString());
        }
        return contentWithNumberPlaceHolder;
    }

    public static String formatStr(String contentWithNumberPlaceHolder, Object ... numberReplaceParams) {
        for (int i = 0; i < numberReplaceParams.length; ++i) {
            contentWithNumberPlaceHolder = contentWithNumberPlaceHolder.replace("{" + i + "}", numberReplaceParams[i].toString());
        }
        return contentWithNumberPlaceHolder;
    }

    public static String formatByMap(String contentWithKeyPlaceHolder, Map<String, String> keyReplaceParams) {
        String result = contentWithKeyPlaceHolder;
        if (keyReplaceParams == null || keyReplaceParams.isEmpty()) {
            return result;
        }
        for (String key : keyReplaceParams.keySet()) {
            String value = keyReplaceParams.get(key);
            if (value == null) continue;
            result = result.replace("${" + key + "}", value.toString());
        }
        return result;
    }

    public static String formatByMap(String contentWithKeyPlaceHolder, String open, String close, Map<String, Map<String, Object>> keyReplaceParams) {
        String result = contentWithKeyPlaceHolder;
        if (keyReplaceParams == null || keyReplaceParams.isEmpty()) {
            return result;
        }
        for (String key : keyReplaceParams.keySet()) {
            Map<String, Object> valueMap = keyReplaceParams.get(key);
            if (valueMap == null) continue;
            if ("java.lang.Integer".equals(valueMap.get(CLASS_KEY))) {
                result = result.replace(open + key + close, valueMap.get(VALUE_KEY).toString());
                continue;
            }
            if ("java.lang.Double".equals(valueMap.get(CLASS_KEY))) {
                result = result.replace(open + key + close, valueMap.get(VALUE_KEY).toString());
                continue;
            }
            if ("java.lang.String".equals(valueMap.get(CLASS_KEY))) {
                result = result.replace(open + key + close, "'" + valueMap.get(VALUE_KEY).toString() + "'");
                continue;
            }
            result = result.replace(open + key + close, "'" + valueMap.get(VALUE_KEY).toString() + "'");
        }
        return result;
    }

    public static String formatWithQuote(Object obj, boolean isFormatWithQuote) {
        StringBuilder sb = new StringBuilder();
        if (obj == null) {
            sb.append("NULL");
        } else if (obj instanceof Object[]) {
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                sb.append(((Object[])obj)[i]).append(", ");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
        } else {
            sb.append(obj.toString());
        }
        if (!(!isFormatWithQuote || sb.length() <= 0 || sb.charAt(0) == '[' && sb.charAt(sb.length() - 1) == ']' || sb.charAt(0) == '{' && sb.charAt(sb.length() - 1) == '}')) {
            sb.insert(0, "[").append("]");
        }
        return sb.toString();
    }

    public static String replace(String contentWithBraces, String replaceContent) {
        return StringFormater.replace(contentWithBraces, replaceContent, "\\{(.*?)\\}");
    }

    public static String replace(String contentWithBraces, String replaceContent, String regularCompare) {
        Pattern regex = Pattern.compile(regularCompare);
        String result = contentWithBraces;
        Matcher regexMatcher = regex.matcher(result);
        while (regexMatcher.find()) {
            String toReplace = regexMatcher.group(0);
            result = result.replace(toReplace, replaceContent);
            regexMatcher = regex.matcher(result);
        }
        return result;
    }

    public static String replaceByMap(String contentWithBraces, Map<String, String> replaceParamMap) {
        return StringFormater.replaceByMap(contentWithBraces, replaceParamMap, "\\{(.*?)\\}");
    }

    public static String replaceByMap(String contentWithBraces, Map<String, String> replaceParamMap, String regularCompare) {
        Pattern regex = Pattern.compile(regularCompare);
        Matcher regexMatcher = regex.matcher(contentWithBraces);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            String value = replaceParamMap.get(key);
            if (value == null) continue;
            contentWithBraces = contentWithBraces.replace(toReplace, value);
        }
        return contentWithBraces;
    }

    public static Map<String, String> transferKeyAndToReplace(String contentWithBraces, String regularCompare) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Pattern regex = Pattern.compile(regularCompare);
        Matcher regexMatcher = regex.matcher(contentWithBraces);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            resultMap.put(key, toReplace);
        }
        return resultMap;
    }

    public static String desensitizMobile(String mobile) {
        if (StringValidator.isMobile(mobile)) {
            return StringFormater.desensitiz(mobile, "(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        return mobile;
    }

    public static String desensitizIdCard(String idCard) {
        if (StringValidator.isMobile(idCard)) {
            return StringFormater.desensitiz(idCard, "(\\w{10})\\w*(\\w{2})", "$1******$2");
        }
        return idCard;
    }

    public static String desensitiz(String input, String regex, String format) {
        return input.replaceAll(regex, format);
    }
}

