/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.time;

import com.hy.apaas.base.core.util.string.StringUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatUtil {
    @Deprecated
    protected static final DateFormat DATE_FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_DATETIME_NOSECOND = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_DATETIME_NOMINUTE = new SimpleDateFormat("yyyy-MM-dd HH");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_TIME = new SimpleDateFormat("HH:mm:ss");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_TIME_NOSECOND = new SimpleDateFormat("HH:mm");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_SHORT_DATE = new SimpleDateFormat("yyyyMMdd");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_SHORT_MONTH = new SimpleDateFormat("yyyyMM");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_MONTH = new SimpleDateFormat("yyyy-MM");
    @Deprecated
    protected static final DateFormat DATE_FORMAT_YEAR = new SimpleDateFormat("yyyy");
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_DATE_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_DATETIME_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_DATETIME_NOSECOND_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_DATETIME_NOMINUTE_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_TIME_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_TIME_NOSECOND_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_TIMESTAMP_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_SHORT_DATE_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_SHORT_MONTH_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMM");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_MONTH_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM");
        }
    };
    protected static final ThreadLocal<DateFormat> DATE_FORMAT_YEAR_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy");
        }
    };
    protected static Logger logger = LoggerFactory.getLogger(DateFormatUtil.class);

    private DateFormatUtil() {
    }

    public static Date parse(String dateString) {
        if (dateString == null) {
            return null;
        }
        String[] styles = new String[]{"yyyy", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM", "HH:mm:ss", "HH:mm", "yyyy-MM-dd HH:mm:ss.SSS"};
        return DateFormatUtil.parse(dateString, styles);
    }

    public static Date parse(String dateString, String style) throws ParseException {
        return DateUtils.parseDate((String)dateString, (String[])new String[]{style});
    }

    public static String format(Object date) {
        if (date instanceof Timestamp) {
            return DATE_FORMAT_TIMESTAMP_LOCAL.get().format(date);
        }
        if (date instanceof Time) {
            return DATE_FORMAT_TIME_LOCAL.get().format(date);
        }
        if (date instanceof java.sql.Date) {
            return DATE_FORMAT_DATE_LOCAL.get().format(date);
        }
        return DATE_FORMAT_DATETIME_LOCAL.get().format(date);
    }

    public static Date parse(String dateString, String ... style) {
        Date date = null;
        if (StringUtil.isEmpty((CharSequence)dateString)) {
            return date;
        }
        try {
            date = DateUtils.parseDate((String)dateString, (String[])style);
        }
        catch (Exception e) {
            logger.error("Parse the date(" + dateString + ") occur errors:" + e.getMessage());
        }
        return date;
    }

    public static String format(Date date, String style) {
        return DateFormatUtils.format((Date)date, (String)style);
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DATE_FORMAT_DATE_LOCAL.get().parse(dateString);
    }

    public static String formatDate(Date date) {
        return DATE_FORMAT_DATE_LOCAL.get().format(date);
    }

    public static Date parseDateTime(String dateString) throws ParseException {
        return DATE_FORMAT_DATETIME_LOCAL.get().parse(dateString);
    }

    public static String formatDatetTime(Date date) {
        return DATE_FORMAT_DATETIME_LOCAL.get().format(date);
    }

    public static String formatDateTime(Date date) {
        return DATE_FORMAT_DATETIME_LOCAL.get().format(date);
    }

    public static String formatTimeNoSecond(Date date) {
        return DATE_FORMAT_DATETIME_NOSECOND_LOCAL.get().format(date);
    }

    public static Date parseTimeNoSecond(String dateString) throws ParseException {
        return DATE_FORMAT_DATETIME_NOSECOND_LOCAL.get().parse(dateString);
    }

    public static String format(long millisecond) {
        Date date = new Date(millisecond);
        return DateFormatUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(long millisecond, String style) {
        Date date = new Date(millisecond);
        return DateFormatUtil.format(date, style);
    }

    public static String getCurrentTime() {
        return DateFormatUtil.getCurrentTime(null);
    }

    public static String getCurrentDate() {
        return DateFormatUtil.formatDate(new Date());
    }

    public static String getNowYMD() {
        return DATE_FORMAT_SHORT_DATE_LOCAL.get().format(new Date());
    }

    public static String getNowYM() {
        return DATE_FORMAT_SHORT_MONTH_LOCAL.get().format(new Date());
    }

    public static String getNowY() {
        return DATE_FORMAT_YEAR_LOCAL.get().format(new Date());
    }

    public static String getNowPart(String format) {
        return DateFormatUtils.format((Date)new Date(), (String)format);
    }

    public static String getCurrentTime(String style) {
        if (StringUtil.isEmpty((CharSequence)style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        return DateFormatUtil.format(new Date(), style);
    }
}

