/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.time;

import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.string.StringUtil;
import com.hy.apaas.base.core.util.time.DateFormatUtil;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil
extends DateUtils {
    protected Logger logger = LoggerFactory.getLogger(DateUtil.class);

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Date setAsBegin(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date setAsEnd(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String getCurrentTime(String style) {
        if (StringUtil.isEmpty((CharSequence)style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        return DateFormatUtil.format(new Date(), style);
    }

    public static String getCurrentTime() {
        return DateUtil.getCurrentTime("");
    }

    public static Date getCurrentDate() {
        return Calendar.getInstance().getTime();
    }

    public static long getCurrentTimeInMillis() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static Date[] getDaysBetween(Date startDate, Date endDate) {
        long day = (startDate.getTime() - endDate.getTime()) / 86400000L > 0L ? (startDate.getTime() - endDate.getTime()) / 86400000L : (endDate.getTime() - startDate.getTime()) / 86400000L;
        Date[] dateArr = new Date[Integer.valueOf(String.valueOf(day + 1L)).intValue()];
        for (int i = 0; i < dateArr.length; ++i) {
            if (i == 0) {
                dateArr[i] = DateUtil.setAsBegin(startDate);
                continue;
            }
            Date nextDay = DateUtil.addDays((Date)startDate, (int)1);
            dateArr[i] = startDate = DateUtil.setAsBegin(nextDay);
        }
        return dateArr;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        return cal.getActualMaximum(5);
    }

    public static int getWeekDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, 1);
        return cal.get(7);
    }

    public static boolean compare(String beginDateStr, String endDateStr) {
        try {
            Date beginDate = DateFormatUtil.parse(beginDateStr);
            Date endDate = DateFormatUtil.parse(endDateStr);
            return DateUtil.compare(beginDate, endDate);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean compare(Date beginDate, Date endDate) {
        try {
            return beginDate.compareTo(endDate) < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int compareTo(String beginDateStr, String endDateStr) {
        try {
            Date beginDate = DateFormatUtil.parse(beginDateStr);
            Date endDate = DateFormatUtil.parse(endDateStr);
            return DateUtil.compareTo(beginDate, endDate);
        }
        catch (Exception e) {
            return -2;
        }
    }

    public static int compareTo(Date beginDate, Date endDate) {
        try {
            return beginDate.compareTo(endDate);
        }
        catch (Exception e) {
            return -2;
        }
    }

    public static Date getDate(int year, int month, int date) {
        return DateUtil.getDate(year, month, date, 0, 0, 0);
    }

    public static Date getDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, date, hourOfDay, minute, second);
        return cal.getTime();
    }

    public static long getTime(Date startTime, Date endTime) {
        return endTime.getTime() - startTime.getTime();
    }

    public static String getDurationTime(Date date) {
        return DateUtil.getDurationTime(date, new Date());
    }

    public static String getDurationTime(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return "";
        }
        Long millseconds = DateUtil.getTime(startTime, new Date());
        return DateUtil.getTime(millseconds);
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static String getTime(Long millseconds) {
        long minuteMillseconds;
        long minutes;
        long hourMillseconds;
        long hours;
        StringBuilder time = new StringBuilder();
        if (millseconds == null) {
            return "";
        }
        long days = millseconds / 1000L / 60L / 60L / 24L;
        if (days > 0L) {
            time.append(days).append("\u5929");
        }
        if ((hours = (hourMillseconds = millseconds - days * 1000L * 60L * 60L * 24L) / 1000L / 60L / 60L) > 0L) {
            time.append(hours).append("\u5c0f\u65f6");
        }
        if ((minutes = (minuteMillseconds = millseconds - days * 1000L * 60L * 60L * 24L - hours * 1000L * 60L * 60L) / 1000L / 60L) > 0L) {
            time.append(minutes).append("\u5206\u949f");
        }
        return time.toString();
    }

    public static String timeAgo(Date date) {
        return DateUtil.timeAgo(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeAgo(Date date, String style) {
        long stamp = new Date().getTime() - date.getTime();
        if (stamp > 2592000000L) {
            return DateFormatUtil.format(date, style);
        }
        if (stamp >= 86400000L) {
            return (stamp / 1000L / 60L / 60L / 24L | 0L) + "\u5929\u524d";
        }
        if (stamp >= 3600000L) {
            return (stamp / 1000L / 60L / 60L | 0L) + "\u5c0f\u65f6\u524d";
        }
        if (stamp >= 180000L) {
            return (stamp / 1000L / 60L | 0L) + "\u5206\u949f\u524d";
        }
        if (stamp < 0L) {
            return "\u672a\u6765";
        }
        return "\u521a\u521a";
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date parse(String paramValue, String datefmt) {
        Date date = null;
        if (StringUtil.isNotEmpty((CharSequence)datefmt)) {
            try {
                date = DateFormatUtil.parse(paramValue, datefmt);
            }
            catch (ParseException parseException) {}
        } else {
            date = DateFormatUtil.parse(paramValue);
        }
        return date;
    }

    public static Date parse(String paramValue, String datefmt, Boolean isSame) {
        Date date = null;
        if (StringUtil.isNotEmpty((CharSequence)datefmt)) {
            try {
                date = DateFormatUtil.parse(paramValue, datefmt);
            }
            catch (ParseException parseException) {}
        } else {
            date = DateFormatUtil.parse(paramValue);
        }
        if (isSame.booleanValue()) {
            return DateUtil.handleSame(paramValue, date, datefmt);
        }
        return date;
    }

    private static Date handleSame(String paramValue, Date date, String datefmt) {
        if (BeanUtils.isEmpty(date)) {
            return date;
        }
        if (StringUtil.isEmpty((CharSequence)datefmt)) {
            datefmt = DateUtil.getDatefmt(paramValue);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (DateUtil.isContain(datefmt, "[y]+")) {
            if (DateUtil.isContain(datefmt, "[M]+")) {
                if (DateUtil.isContain(datefmt, "[d]+")) {
                    if (DateUtil.isContain(datefmt, "[Hh]+")) {
                        if (DateUtil.isContain(datefmt, "[m]+")) {
                            if (DateUtil.isContain(datefmt, "[s]+")) {
                                cal.add(13, 1);
                            } else {
                                cal.add(12, 1);
                            }
                        } else {
                            cal.add(10, 1);
                        }
                    } else {
                        cal.add(5, 1);
                    }
                } else {
                    cal.add(2, 1);
                }
            } else {
                cal.add(1, 1);
            }
            cal.add(14, -1);
            date = cal.getTime();
        }
        return date;
    }

    private static boolean isContain(String datefmt, String reg) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(datefmt);
            fmt.format(new Date());
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(datefmt);
            if (matcher.find()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static String getDatefmt(String paramValue) {
        String datefmt = null;
        String[] parsePatterns = new String[]{"yyyy", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM", "HH:mm:ss", "HH:mm", "yyyy-MM-dd HH:mm:ss.SSS"};
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(true);
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < parsePatterns.length; ++i) {
            Date date1;
            String pattern = parsePatterns[i];
            if (parsePatterns[i].endsWith("ZZ")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            parser.applyPattern(pattern);
            pos.setIndex(0);
            String str2 = paramValue;
            if (parsePatterns[i].endsWith("ZZ")) {
                int signIdx = DateUtil.indexOfSignChars(str2, 0);
                while (signIdx >= 0) {
                    str2 = DateUtil.reformatTimezone(str2, signIdx);
                    ++signIdx;
                    signIdx = DateUtil.indexOfSignChars(str2, signIdx);
                }
            }
            if ((date1 = parser.parse(str2, pos)) == null || pos.getIndex() != str2.length()) continue;
            datefmt = pattern;
        }
        return datefmt;
    }

    private static int indexOfSignChars(String str, int startPos) {
        int idx = StringUtil.indexOf((CharSequence)str, (int)43, (int)startPos);
        if (idx < 0) {
            idx = StringUtil.indexOf((CharSequence)str, (int)45, (int)startPos);
        }
        return idx;
    }

    private static String reformatTimezone(String str, int signIdx) {
        String str2 = str;
        if (signIdx >= 0 && signIdx + 5 < str.length() && Character.isDigit(str.charAt(signIdx + 1)) && Character.isDigit(str.charAt(signIdx + 2)) && str.charAt(signIdx + 3) == ':' && Character.isDigit(str.charAt(signIdx + 4)) && Character.isDigit(str.charAt(signIdx + 5))) {
            str2 = str.substring(0, signIdx + 3) + str.substring(signIdx + 4);
        }
        return str2;
    }
}

