/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core;

import com.hy.apaas.base.core.context.DefaultThreadContext;
import com.hy.apaas.base.core.context.ThreadContext;
import com.hy.apaas.base.core.util.EnvUtil;
import com.hy.apaas.base.core.util.I18nUtil;
import com.hy.apaas.base.core.util.ThreadContextUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ConditionalOnProperty(prefix="com.hy.core", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AutoConfigure {
    @Bean
    @DependsOn(value={"defaultThreadContext"})
    public EnvUtil envUtil() {
        return new EnvUtil();
    }

    @Bean
    @ConditionalOnMissingBean(value={ThreadContext.class})
    public ThreadContext defaultThreadContext() {
        return new DefaultThreadContext();
    }

    @Bean(initMethod="init")
    @DependsOn(value={"envUtil"})
    public ThreadContextUtil threadContextUtil() {
        return new ThreadContextUtil();
    }

    @Bean(initMethod="init")
    @DependsOn(value={"envUtil"})
    public I18nUtil i18nUtil() {
        return new I18nUtil();
    }
}

