/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.exception.spi;

import com.hy.apaas.base.core.exception.NotRequiredI18nException;
import com.hy.apaas.base.core.exception.spi.AbstractSpiExceptionService;
import com.hy.apaas.base.core.util.ExceptionUtil;
import com.hy.apaas.base.core.util.I18nUtil;
import com.hy.apaas.base.core.util.string.StringUtil;
import org.springframework.data.util.Pair;

public class NotRequiredI18nSpiException
extends AbstractSpiExceptionService {
    @Override
    public String getClassName() {
        return NotRequiredI18nException.class.getName();
    }

    @Override
    public Pair<Integer, String> doAnalysisWithState(Exception exception) {
        if (exception == null) {
            return Pair.of((Object)-500, (Object)I18nUtil.getMessage("state.-500"));
        }
        NotRequiredI18nException cause = (NotRequiredI18nException)exception;
        if (cause.getCause() == null) {
            return Pair.of((Object)cause.getState(), (Object)cause.getMessage());
        }
        return ExceptionUtil.analysisCauseWithState(cause.getCause());
    }

    @Override
    public Pair<Integer, String> doAnalysisWithState(Throwable throwable) {
        if (throwable == null) {
            return Pair.of((Object)-500, (Object)I18nUtil.getMessage("state.-500"));
        }
        NotRequiredI18nException cause = (NotRequiredI18nException)throwable;
        if (cause.getCause() == null) {
            return Pair.of((Object)cause.getState(), (Object)cause.getMessage());
        }
        return ExceptionUtil.analysisCauseWithState(cause.getCause());
    }

    @Override
    public String doAnalysis(Exception exception) {
        if (exception == null) {
            return "Non";
        }
        StringBuilder message = new StringBuilder();
        NotRequiredI18nException cause = (NotRequiredI18nException)exception;
        if (cause.getCause() == null) {
            String errorMessage = cause.getMessage();
            String error = StringUtil.isBlank((CharSequence)errorMessage) ? "Non" : errorMessage;
            message.append(error);
        } else {
            message.append(ExceptionUtil.analysisCause(cause.getCause()));
        }
        return message.toString();
    }

    @Override
    public String doAnalysis(Throwable throwable) {
        if (throwable == null) {
            return "Non";
        }
        StringBuilder message = new StringBuilder();
        NotRequiredI18nException cause = (NotRequiredI18nException)throwable;
        if (cause.getCause() == null) {
            String errorMessage = cause.getMessage();
            String error = StringUtil.isBlank((CharSequence)errorMessage) ? "Non" : errorMessage;
            message.append(error);
        } else {
            message.append(ExceptionUtil.analysisCause(cause.getCause()));
        }
        return message.toString();
    }
}

