/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.util.KryoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collections
extends CollectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Collections.class);

    private Collections() {
    }

    public static boolean isEmpty(Collection c) {
        if (CollectionUtils.isEmpty((Collection)c)) {
            return true;
        }
        return c.size() == 0;
    }

    public static <T> Collection<T> deepCopy(Collection<T> src) {
        try {
            return KryoUtil.copy(src);
        }
        catch (Exception ex) {
            return Collections.jdkCopy(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Collection<T> jdkCopy(Collection<T> src) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        ByteArrayInputStream byteIn = null;
        ObjectInputStream in = null;
        Collection dest = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            in = new ObjectInputStream(byteIn);
            dest = (Collection)in.readObject();
        }
        catch (IOException e) {
            LOGGER.error("clone object failed {}.", (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("class not found {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return dest;
    }
}

