/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.exception.BaseException;
import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.FileUtil;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Dom4jUtil {
    private static final Logger logger = LoggerFactory.getLogger(Dom4jUtil.class);
    private static final String TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final String TRANSFORMER_FACTORY_IMPL = "org.apache.xalan.processor.TransformerFactoryImpl";

    private Dom4jUtil() {
    }

    public static Document loadXml(String s) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)s);
        }
        catch (Exception ex) {
            logger.error("load XML string error:{}", (Object)ex.getMessage());
        }
        return document;
    }

    public static Document load(String filename, String encode) {
        Document document = null;
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEncoding(encode);
            document = saxReader.read(new File(filename));
        }
        catch (Exception ex) {
            logger.error("load XML File error:{}", (Object)ex.getMessage());
        }
        return document;
    }

    public static Document loadXml(String xml, String encode) throws UnsupportedEncodingException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(encode));
        return Dom4jUtil.loadXml(inputStream, encode);
    }

    public static Document loadXml(InputStream is) {
        return Dom4jUtil.loadXml(is, "UTF-8");
    }

    public static Document loadXml(InputStream is, String charset) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding(charset);
            document = reader.read(is);
        }
        catch (Exception ex) {
            logger.error("load XML File error:{}", (Object)ex.getMessage());
        }
        return document;
    }

    public static void write(Document document, String fileName) throws IOException {
        String xml = document.asXML();
        FileUtil.writeFile(fileName, xml);
    }

    public static void write(String str, String fileName) throws IOException, DocumentException {
        Document document = DocumentHelper.parseText((String)str);
        Dom4jUtil.write(document, fileName);
    }

    public Document load(URL url) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(url);
    }

    public static Document load(String filename) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(new File(filename));
            document.normalize();
        }
        catch (Exception ex) {
            logger.error("load XML File error:{}", (Object)ex.getMessage());
        }
        return document;
    }

    public static Document loadByClassPath(String filePath) throws IOException, DocumentException {
        return Dom4jUtil.loadByClassPath(filePath, "UTF-8");
    }

    public static Document loadByClassPath(String filePath, String charset) throws IOException, DocumentException {
        return Dom4jUtil.loadByClassPath(filePath, charset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadByClassPath(String filePath, String charset, ClassLoader classLoader) throws IOException, DocumentException {
        InputStreamReader isr = null;
        Document document = null;
        URL url = null;
        url = classLoader != null ? classLoader.getResource("/" + filePath) : Dom4jUtil.class.getResource("/" + filePath);
        try {
            isr = new InputStreamReader(url.openStream());
            SAXReader reader = new SAXReader();
            reader.setEncoding(charset);
            document = reader.read((Reader)isr);
            document.normalize();
            Document document2 = document;
            return document2;
        }
        finally {
            if (isr != null) {
                isr.close();
            }
        }
    }

    public static String transFormXsl(String xml, String xsl, Map<String, String> map) {
        StringWriter writer = new StringWriter();
        try {
            StringReader xmlReader = new StringReader(xml);
            StringReader xslReader = new StringReader(xsl);
            System.setProperty(TRANSFORMER_FACTORY, TRANSFORMER_FACTORY_IMPL);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslReader));
            if (map != null) {
                for (Map.Entry<String, String> obj : map.entrySet()) {
                    transformer.setParameter(obj.getKey(), obj.getValue());
                }
            }
            StreamSource xmlSource = new StreamSource(xmlReader);
            StreamResult result = new StreamResult(writer);
            transformer.transform(xmlSource, result);
        }
        catch (TransformerException e) {
            throw new BaseException(e.getCause());
        }
        return writer.toString();
    }

    public static String transXmlByXslt(String xml, String xslPath, Map<String, String> map) {
        Document document = Dom4jUtil.loadXml(xml);
        if (BeanUtils.isEmpty(document)) {
            return "";
        }
        document.setXMLEncoding("UTF-8");
        Document result = Dom4jUtil.styleDocument(document, xslPath, map);
        return Dom4jUtil.docToString(result);
    }

    public static String transXmlByXslt(String xml, InputStream styleStream, Map<String, String> map) {
        Document document = Dom4jUtil.loadXml(xml);
        if (BeanUtils.isEmpty(document)) {
            return "";
        }
        document.setXMLEncoding("UTF-8");
        Document result = Dom4jUtil.styleDocument(document, styleStream, map);
        return Dom4jUtil.docToString(result);
    }

    public static String transFileXmlByXslt(String xmlPath, String xslPath, Map<String, String> map) {
        Document document = Dom4jUtil.load(xmlPath);
        if (BeanUtils.isEmpty(document)) {
            return "";
        }
        document.setXMLEncoding("UTF-8");
        Document result = Dom4jUtil.styleDocument(document, xslPath, map);
        return Dom4jUtil.docToString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String docToString(Document document) {
        String s = "";
        ByteArrayOutputStream out = null;
        XMLWriter writer = null;
        try {
            out = new ByteArrayOutputStream();
            OutputFormat format = new OutputFormat("  ", true, "UTF-8");
            writer = new XMLWriter((OutputStream)out, format);
            writer.write(document);
            s = out.toString("UTF-8");
        }
        catch (Exception ex) {
            logger.error("docToString error:{}", (Object)ex.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != writer) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String docToPrettyString(Document document) {
        String s = "";
        StringWriter writer = null;
        XMLWriter xmlWriter = null;
        try {
            writer = new StringWriter();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(true);
            xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            s = ((Object)writer).toString();
        }
        catch (Exception ex) {
            logger.error("docToString error:{}", (Object)ex.getMessage());
        }
        finally {
            try {
                if (null != xmlWriter) {
                    xmlWriter.close();
                }
                if (null != writer) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
        return s;
    }

    public static Document styleDocument(Document document, String stylesheet, Map<String, String> map) {
        Document transformedDoc = null;
        try {
            System.setProperty(TRANSFORMER_FACTORY, TRANSFORMER_FACTORY_IMPL);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(stylesheet));
            if (map != null) {
                for (Map.Entry<String, String> obj : map.entrySet()) {
                    transformer.setParameter(obj.getKey(), obj.getValue());
                }
            }
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            transformedDoc = result.getDocument();
        }
        catch (TransformerException e) {
            throw new BaseException(e.getCause());
        }
        return transformedDoc;
    }

    public static Document styleDocument(Document document, InputStream stylesheetStream, Map<String, String> map) {
        Document transformedDoc = null;
        try {
            System.setProperty(TRANSFORMER_FACTORY, TRANSFORMER_FACTORY_IMPL);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(stylesheetStream));
            if (map != null) {
                for (Map.Entry<String, String> obj : map.entrySet()) {
                    transformer.setParameter(obj.getKey(), obj.getValue());
                }
            }
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            transformedDoc = result.getDocument();
        }
        catch (TransformerException e) {
            throw new BaseException(e.getCause());
        }
        return transformedDoc;
    }

    public static boolean validateXMLSchema(String xml, File ... xsdFiles) {
        return Dom4jUtil.validateXMLSchema((InputStream)new ByteArrayInputStream(xml.getBytes()), xsdFiles);
    }

    public static boolean validateXMLSchema(InputStream xmlIs, File ... xsdFiles) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
            for (File file : xsdFiles) {
                sourceList.add(new StreamSource(file));
            }
            Source[] sources = sourceList.toArray(new Source[0]);
            Schema schema = factory.newSchema(sources);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xmlIs));
        }
        catch (IOException | SAXException e) {
            logger.error("validate XML File error:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean validateXMLSchema(InputStream xmlIs, InputStream ... xsdIses) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
            for (InputStream xsdIs : xsdIses) {
                sourceList.add(new StreamSource(xsdIs));
            }
            Source[] sources = sourceList.toArray(new Source[0]);
            Schema schema = factory.newSchema(sources);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xmlIs));
        }
        catch (IOException | SAXException e) {
            logger.error("validate XML File error:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static List<Element> elements(Element element, String targetName) {
        ArrayList<Element> result = new ArrayList<Element>();
        List elems = element.elements();
        Element elm2 = null;
        if (BeanUtils.isNotEmpty(elems)) {
            for (Element elm2 : elems) {
                if (targetName.equalsIgnoreCase(elm2.getName())) {
                    result.add(elm2);
                    continue;
                }
                result.addAll(Dom4jUtil.elements(elm2, targetName));
            }
        }
        return result;
    }

    public static List<Element> elements(Document element, String targetName) {
        return Dom4jUtil.elements(element.getRootElement(), targetName);
    }

    public static String getString(Element element, String attrName) {
        return Dom4jUtil.getString(element, attrName, false);
    }

    public static String getString(Element element, String attrName, Boolean fuzzy) {
        if (element == null) {
            return null;
        }
        String val = element.attributeValue(attrName);
        if (StringUtil.isEmpty((CharSequence)val)) {
            return null;
        }
        if (fuzzy.booleanValue()) {
            val = "%" + val + "%";
        }
        return val;
    }

    public static String readXml(String url, String charsetName) {
        SAXReader reader = new SAXReader();
        reader.setEncoding(charsetName);
        Document document = null;
        try {
            document = reader.read(url);
        }
        catch (DocumentException e) {
            logger.error("read XML File error:{}", (Object)e.getMessage());
        }
        if (null == document) {
            return "";
        }
        return document.asXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writerXml(String xml, String charsetName, String path) {
        XMLWriter xmlWriter = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(charsetName);
            xmlWriter = new XMLWriter((OutputStream)new FileOutputStream(path), format);
            Document doc = DocumentHelper.parseText((String)xml);
            xmlWriter.write(doc);
        }
        catch (Exception e) {
            logger.error("write XML File error:{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (null != xmlWriter) {
                    xmlWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

