/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.hy.apaas.base.core.context.ThreadContext;
import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.ConvertUtil;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class EnvUtil
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(EnvUtil.class);

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Inner.setContext(context);
    }

    public static void setOnlineContext(ApplicationContext context) throws BeansException {
        Inner.setContext(context);
    }

    public static ApplicationContext getApplicaitonContext() {
        return Inner.getContext();
    }

    public static void refreshContext() {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)Inner.getContext();
        configurableApplicationContext.refresh();
    }

    public static void registerBean(Class<?> ... cls) {
        EnvUtil.registerBean(Inner.getContext(), cls);
    }

    public static void registerBean(String beanId, Class<?> cls) {
        EnvUtil.registerBean(Inner.getContext(), beanId, cls);
    }

    public static void registerBean(String beanId, String alias) {
        EnvUtil.registerBean(Inner.getContext(), beanId, alias);
    }

    public static void registerBean(String beanId, Object bean) {
        EnvUtil.registerBean(Inner.getContext(), beanId, bean);
    }

    public static void unregisterBean(String beanId) {
        EnvUtil.unregisterBean(Inner.getContext(), beanId);
    }

    public static void scanBeans(String ... basePackages) {
        EnvUtil.scanBeans(Inner.getContext(), basePackages);
    }

    public static void registerBean(ApplicationContext context, Class<?> ... cls) {
        for (Class<?> cs : cls) {
            EnvUtil.registerBean(context, StringUtil.lowerFirst(cs.getSimpleName()), cs);
        }
    }

    public static void registerBean(ApplicationContext context, String beanId, Class<?> cls) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(cls);
        defaultListableBeanFactory.registerBeanDefinition(beanId, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        if (logger.isDebugEnabled()) {
            logger.debug("register class {} {}.", (Object)beanId, (Object)"success");
        }
    }

    public static void registerBean(ApplicationContext context, String beanId, String alias) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
        defaultListableBeanFactory.registerAlias(beanId, alias);
        if (logger.isDebugEnabled()) {
            logger.debug("register class {} {}.", (Object)beanId, (Object)"success");
        }
    }

    public static void registerBean(ApplicationContext context, String beanId, Object bean) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
        defaultListableBeanFactory.registerSingleton(beanId, bean);
        if (logger.isDebugEnabled()) {
            logger.debug("register class {} {}.", (Object)beanId, (Object)"success");
        }
    }

    public static void unregisterBean(ApplicationContext context, String beanId) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
        defaultListableBeanFactory.removeBeanDefinition(beanId);
        if (logger.isDebugEnabled()) {
            logger.debug("Unregister {} {}.", (Object)beanId, (Object)"success");
        }
    }

    public static void scanBeans(ApplicationContext context, String ... basePackages) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        for (String basePackage : basePackages) {
            ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(beanDefinitionRegistry);
            int scan = scanner.scan(new String[]{basePackage});
            EnvUtil.loadBeans(scan, basePackage, scanner);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("after bean count is {} .", (Object)beanDefinitionRegistry.getBeanDefinitionCount());
            logger.debug("scan {} beans from package {} .", (Object)scan, (Object)basePackage);
        }
    }

    private static void loadBeans(int scan, String basePackage, ClassPathBeanDefinitionScanner scanner) {
        if (scan == 0) {
            return;
        }
        Set candidates = scanner.findCandidateComponents(basePackage);
        for (BeanDefinition candidate : candidates) {
            String beanClassName = candidate.getBeanClassName();
            try {
                EnvUtil.getBean(Class.forName(beanClassName), true);
            }
            catch (ClassNotFoundException e) {
                logger.error("{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static List<String> scanPackages(String basePackages) throws IllegalArgumentException {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)rl);
        ArrayList<String> result = new ArrayList<String>();
        String[] arrayPackages = basePackages.split(",");
        try {
            for (int j = 0; j < arrayPackages.length; ++j) {
                String packageToScan = arrayPackages[j];
                String packagePart = packageToScan.replace('.', '/');
                String classPattern = "classpath*:/" + packagePart + "/**/*.class";
                Resource[] resources = rl.getResources(classPattern);
                for (int i = 0; i < resources.length; ++i) {
                    Resource resource = resources[i];
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    String className = metadataReader.getClassMetadata().getClassName();
                    result.add(className);
                }
            }
        }
        catch (Exception e) {
            new IllegalArgumentException("scan pakcage class error,pakcages:" + basePackages);
        }
        return result;
    }

    public static Object getBean(String beanId) {
        return EnvUtil.getBean(Inner.getContext(), beanId, false);
    }

    public static Object getBean(String beanId, boolean throwexception) {
        return EnvUtil.getBean(Inner.getContext(), beanId, throwexception);
    }

    public static <T> T getBean(Class<T> beanClass) {
        return EnvUtil.getBean(Inner.getContext(), beanClass, false);
    }

    public static <T> T getBean(Class<T> beanClass, boolean throwexception) {
        return EnvUtil.getBean(Inner.getContext(), beanClass, throwexception);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> beanClass) {
        return EnvUtil.getBeansOfType(Inner.getContext(), beanClass, false);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> beanClass, boolean throwexception) {
        return EnvUtil.getBeansOfType(Inner.getContext(), beanClass, throwexception);
    }

    public static Object getBean(ApplicationContext context, String beanId) {
        return EnvUtil.getBean(context, beanId, false);
    }

    public static Object getBean(ApplicationContext context, String beanId, boolean throwexception) {
        try {
            return context.getBean(beanId);
        }
        catch (Exception ex) {
            if (throwexception) {
                logger.error("getBean:" + beanId + "," + ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public static <T> T getBean(ApplicationContext context, Class<T> beanClass) {
        return EnvUtil.getBean(context, beanClass, false);
    }

    public static <T> T getBean(ApplicationContext context, Class<T> beanClass, boolean throwexception) {
        try {
            return (T)context.getBean(beanClass);
        }
        catch (Exception ex) {
            if (throwexception) {
                logger.error("getBean:" + beanClass + "," + ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public static <T> Map<String, T> getBeansOfType(ApplicationContext context, Class<T> beanClass) {
        return EnvUtil.getBeansOfType(context, beanClass, false);
    }

    public static <T> Map<String, T> getBeansOfType(ApplicationContext context, Class<T> beanClass, boolean throwexception) {
        try {
            return context.getBeansOfType(beanClass);
        }
        catch (Exception ex) {
            if (throwexception) {
                logger.error("getBean:" + beanClass + "," + ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public static String getProperty(String property) {
        return EnvUtil.getProperty(property, "");
    }

    public static String getProperty(String property, String defaultValue) {
        return EnvUtil.getProperty(Inner.env, property, defaultValue);
    }

    public static <T> T getProperty(String property, Class<T> targetType) {
        return EnvUtil.getProperty(Inner.env, property, targetType);
    }

    public static <T> T getProperty(String property, Class<T> targetType, T defaultValue) {
        return EnvUtil.getProperty(Inner.env, property, targetType, defaultValue);
    }

    public static String getProperty(String property, String defaultValue, boolean allowBlank) {
        return EnvUtil.getProperty(Inner.env, property, defaultValue, allowBlank);
    }

    public static <T> T getProperty(String property, Class<T> targetType, T defaultValue, boolean allowBlank) {
        return EnvUtil.getProperty(Inner.env, property, targetType, defaultValue, allowBlank);
    }

    public static void publishEvent(ApplicationEvent event) {
        Inner.getContext().publishEvent(event);
    }

    public static String getProperty(Environment env, String property, String defaultValue) {
        Object obj = Inner.getThreadContext().getProperty(property);
        if (BeanUtils.isEmpty(obj)) {
            String v = env.getProperty(property, defaultValue);
            if (StringUtil.isNotEmpty((CharSequence)v)) {
                Inner.getThreadContext().addProperty(property, v);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("getProperty from env: get context Thread ID: " + Thread.currentThread().getId() + ", key=" + property);
            }
            return v;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getProperty from context: get context Thread ID: " + Thread.currentThread().getId() + ", key=" + property);
        }
        return (String)obj;
    }

    public static <T> T getProperty(Environment env, String property, Class<T> targetType) {
        Object obj = Inner.getThreadContext().getProperty(property);
        if (BeanUtils.isEmpty(obj)) {
            Object v = env.getProperty(property, targetType);
            if (BeanUtils.isNotEmpty(v)) {
                Inner.getThreadContext().addProperty(property, v);
            }
            return (T)v;
        }
        return ConvertUtil.convertValueIfNecessary(obj, targetType);
    }

    public static <T> T getProperty(Environment env, String property, Class<T> targetType, T defaultValue) {
        Object obj = Inner.getThreadContext().getProperty(property);
        if (BeanUtils.isEmpty(obj)) {
            Object v = env.getProperty(property, targetType, defaultValue);
            if (BeanUtils.isNotEmpty(v)) {
                Inner.getThreadContext().addProperty(property, v);
            }
            return (T)v;
        }
        return ConvertUtil.convertValueIfNecessary(obj, targetType);
    }

    public static String getProperty(Environment env, String property, String defaultValue, boolean allowBlank) {
        Object obj = Inner.getThreadContext().getProperty(property);
        if (BeanUtils.isEmpty(obj)) {
            String v = env.getProperty(property);
            if (StringUtil.isNotEmpty((CharSequence)v)) {
                Inner.getThreadContext().addProperty(property, v);
            }
            if (allowBlank) {
                return v == null ? defaultValue : v.trim();
            }
            return StringUtil.isEmpty((CharSequence)v) ? defaultValue : v.trim();
        }
        return ConvertUtil.convertValueIfNecessary(obj, String.class);
    }

    public static <T> T getProperty(Environment env, String property, Class<T> targetType, T defaultValue, boolean allowBlank) {
        Object obj = Inner.getThreadContext().getProperty(property);
        if (BeanUtils.isEmpty(obj)) {
            Object v = env.getProperty(property, targetType);
            if (BeanUtils.isNotEmpty(v)) {
                Inner.getThreadContext().addProperty(property, v);
            }
            if (allowBlank) {
                return (T)(v == null ? defaultValue : v);
            }
            return (T)(BeanUtils.isEmpty(v) ? defaultValue : v);
        }
        return ConvertUtil.convertValueIfNecessary(obj, targetType);
    }

    public static boolean isTenant(Environment env) {
        return Boolean.valueOf(EnvUtil.getProperty(env, "auth.tenant", "false"));
    }

    public static String getSysTenantId(Environment env) {
        return EnvUtil.getProperty(env, "auth.tenant.id", "-999", true);
    }

    public static String getAppid(Environment env) {
        return EnvUtil.getProperty(env, "appid", "hy", true);
    }

    public static String getApplicationName() {
        return EnvUtil.getProperty(Inner.env, "spring.application.name");
    }

    public static String getApplicationName(Environment env) {
        return EnvUtil.getProperty(env, "spring.application.name");
    }

    public static String getAppkey(Environment env) {
        return EnvUtil.getProperty(env, "appkey", "apaas", true);
    }

    public static String getBaseUrl(Environment env) {
        return EnvUtil.getProperty(env, "baseUrl", "http://localhost:8080/apaas", false);
    }

    public static String getOriginBaseUrl(Environment env) {
        return EnvUtil.getProperty(env, "originBaseUrl", "http://localhost:8080", false);
    }

    public static String getAppGateWayUrl(Environment env) {
        return EnvUtil.getProperty(env, "gatewayUrl", "http://localhost:8100/apaas/api", false);
    }

    public static boolean isSsl() {
        return EnvUtil.getProperty("server.ssl.enabled", Boolean.class, Boolean.valueOf(false));
    }

    public static String getProtocol() {
        return EnvUtil.isSsl() ? "https://" : "http://";
    }

    public static String getProperty(Environment env, String property) {
        return EnvUtil.getProperty(env, property, "");
    }

    public static <T> List<T> getProperties(Environment env, String property, Class<T> clazz) {
        ArrayList properties = new ArrayList();
        property = property + "[%s]";
        int i = 0;
        Object value = null;
        do {
            if (BeanUtils.isNotEmpty(value = (Object)EnvUtil.getProperty(env, String.format(property, i), clazz))) {
                properties.add(value);
            }
            ++i;
        } while (BeanUtils.isNotEmpty(value));
        properties.remove(null);
        return properties;
    }

    public static <T> T getObjectProperty(Environment env, String property, Class<T> clazz) {
        Field[] fields = ReflectUtil.getFields(clazz);
        Object value = ReflectUtil.newInstance(clazz, (Object[])new Object[0]);
        boolean isNull = true;
        for (Field field : fields) {
            String attribute = property + "." + StrUtil.toSymbolCase((CharSequence)field.getName(), (char)'-');
            String fieldAttribute = property + "." + field.getName();
            Object fielValue = EnvUtil.getProperty(env, attribute, field.getType());
            if (BeanUtils.isNotEmpty(fielValue)) {
                ReflectUtil.setFieldValue((Object)value, (Field)field, fielValue);
                isNull = false;
                continue;
            }
            fielValue = EnvUtil.getProperty(env, fieldAttribute, field.getType());
            if (!BeanUtils.isNotEmpty(fielValue)) continue;
            ReflectUtil.setFieldValue((Object)value, (Field)field, fielValue);
            isNull = false;
        }
        return (T)(isNull ? null : value);
    }

    public static <T> List<T> getObjectProperties(Environment env, String property, Class<T> clazz) {
        ArrayList<Object> properties = new ArrayList<Object>();
        property = property + "[%s]";
        Field[] fields = ReflectUtil.getFields(clazz);
        int i = 0;
        Object value = null;
        boolean isNull = true;
        do {
            isNull = true;
            value = ReflectUtil.newInstance(clazz, (Object[])new Object[0]);
            for (Field field : fields) {
                String attribute = String.format(property, i) + "." + StrUtil.toSymbolCase((CharSequence)field.getName(), (char)'-');
                String fieldAttribute = String.format(property, i) + "." + field.getName();
                Object fvalue = null;
                if (env.containsProperty(attribute)) {
                    fvalue = EnvUtil.getProperty(env, attribute, field.getType());
                    if (!BeanUtils.isNotEmpty(fvalue)) continue;
                    ReflectUtil.setFieldValue((Object)value, (Field)field, fvalue);
                    isNull = false;
                    continue;
                }
                if (!env.containsProperty(fieldAttribute) || !BeanUtils.isNotEmpty(fvalue = EnvUtil.getProperty(env, fieldAttribute, field.getType()))) continue;
                ReflectUtil.setFieldValue((Object)value, (Field)field, fvalue);
                isNull = false;
            }
            if (!isNull) {
                properties.add(value);
            }
            ++i;
        } while (!isNull);
        properties.remove(null);
        return properties;
    }

    private static class Inner {
        private static ApplicationContext context;
        private static Environment env;
        private static ThreadContext threadContext;

        private Inner() {
        }

        public static ApplicationContext getContext() {
            return context;
        }

        public static ThreadContext getThreadContext() {
            return threadContext;
        }

        public static void setContext(ApplicationContext context) {
            Inner.context = context;
            env = Inner.getContext().getEnvironment();
            threadContext = (ThreadContext)Inner.getContext().getBean(ThreadContext.class);
        }
    }
}

