/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.EnvUtil;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nUtil.class);
    private static I18nUtil i18nUtil;
    private MessageSource i18n;

    public I18nUtil init() {
        this.i18n = EnvUtil.getBean(MessageSource.class);
        if (BeanUtils.isEmpty(this.i18n) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("MessageSource is null.");
        }
        i18nUtil = this;
        return this;
    }

    public void setI18n(MessageSource i18n) {
        this.i18n = i18n;
        i18nUtil = this;
    }

    public static String getMessage(String code) {
        return I18nUtil.i18nUtil.i18n.getMessage(code, Collections.emptyList().toArray(), LocaleContextHolder.getLocale());
    }

    public static String getMessage(String code, Object ... args) {
        return I18nUtil.i18nUtil.i18n.getMessage(code, Optional.ofNullable(args).orElse(Collections.emptyList().toArray()), LocaleContextHolder.getLocale());
    }
}

