/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static Logger logger = LoggerFactory.getLogger(JacksonUtil.class);

    private JacksonUtil() {
    }

    public static ObjectMapper mapper() {
        return JacksonUtil.mapper("yyyy-MM-dd HH:mm:ss", null);
    }

    public static ObjectMapper mapper(String dateFormat) {
        return JacksonUtil.mapper(dateFormat, null);
    }

    public static ObjectMapper mapper(String dateFormat, JsonSerializer<Object> nullValueSerializer) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleDateFormat myDateFormat = new SimpleDateFormat(dateFormat);
        mapper.setDateFormat((DateFormat)myDateFormat);
        mapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        if (Objects.nonNull(nullValueSerializer)) {
            mapper.getSerializerProvider().setNullValueSerializer(nullValueSerializer);
        }
        return mapper;
    }

    public static JsonSerializer<Object> createNullStringAsBlankSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object paramT, JsonGenerator paramJsonGenerator, SerializerProvider paramSerializerProvider) throws IOException {
                paramJsonGenerator.writeString("");
            }
        };
    }

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return StringUtil.isNotBlank((CharSequence)o.toString()) && (!JacksonUtil.isJson(o.toString()) || JacksonUtil.isNullJson((String)o) != false);
        }
        return BeanUtils.isEmpty(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !JacksonUtil.isEmpty(o);
    }

    public static boolean isJson(String jsonStr) {
        return JacksonUtil.isJsonObject(jsonStr) || JacksonUtil.isJsonArray(jsonStr);
    }

    public static void assert0(String jsonStr, String message) {
        boolean isJson;
        boolean bl = isJson = JacksonUtil.isJsonObject(jsonStr) || JacksonUtil.isJsonArray(jsonStr);
        if (!isJson) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNotJson(String jsonStr) {
        return !JacksonUtil.isJson(jsonStr);
    }

    public static boolean isJsonObject(String jsonStr) {
        if (StringUtil.isBlank((CharSequence)jsonStr) || !jsonStr.startsWith("{") || !jsonStr.endsWith("}")) {
            return false;
        }
        try {
            JsonNode jsonNode = JacksonUtil.mapper().readTree(jsonStr);
            return jsonNode.isObject();
        }
        catch (Exception e) {
            try {
                jsonStr = jsonStr.replaceAll("\\\"", "\"");
                JsonNode jsonNode = JacksonUtil.mapper().readTree(jsonStr);
                return jsonNode.isObject();
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    public static boolean isNotJsonObject(String jsonStr) {
        return !JacksonUtil.isJsonObject(jsonStr);
    }

    public static boolean isJsonArray(String jsonStr) {
        if (StringUtil.isBlank((CharSequence)jsonStr) || !jsonStr.startsWith("[") || !jsonStr.endsWith("]")) {
            return false;
        }
        try {
            JsonNode jsonNode = JacksonUtil.mapper().readTree(jsonStr);
            return jsonNode.isArray();
        }
        catch (Exception e) {
            try {
                jsonStr = jsonStr.replaceAll("\\\"", "\"");
                JsonNode jsonNode = JacksonUtil.mapper().readTree(jsonStr);
                return jsonNode.isArray();
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    public static boolean isNotJsonArray(String jsonStr) {
        return !JacksonUtil.isJsonArray(jsonStr);
    }

    public static String toJsonString(Object obj) {
        if (BeanUtils.isEmpty(obj)) {
            return null;
        }
        try {
            return JacksonUtil.mapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getString(String data, String key) {
        Map dataMap = JacksonUtil.getDTO(data, Map.class);
        Object d = dataMap.get(key);
        if (d instanceof String) {
            return d.toString();
        }
        return JacksonUtil.toJsonString(dataMap.get(key));
    }

    public static Object get(String data, String key) {
        Map dataMap = JacksonUtil.getDTO(data, Map.class);
        return dataMap.get(key);
    }

    public static Map<String, Object> toMap(String data) {
        return JacksonUtil.getDTO(data, Map.class);
    }

    public static Map<String, Object> toMapRecursion(String data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtil.isBlank((CharSequence)data)) {
            return result;
        }
        Map<String, Object> dataMap = JacksonUtil.toMap(data);
        JacksonUtil.toMapRecursion0(result, dataMap);
        return result;
    }

    public static void toMapRecursion0(Map<String, Object> result, Map<String, Object> dataMap) {
        Set<Map.Entry<String, Object>> entries = dataMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (BeanUtils.isNotEmpty(entry.getValue()) && entry.getValue() instanceof String && JacksonUtil.isJsonObject(entry.getValue().toString())) {
                Map<String, Object> dataMap0 = JacksonUtil.toMapRecursion(entry.getValue().toString());
                result.put(entry.getKey(), dataMap0);
                continue;
            }
            if (BeanUtils.isNotEmpty(entry.getValue()) && entry.getValue() instanceof String && JacksonUtil.isJsonArray(entry.getValue().toString())) {
                List<Map> dataMaps0 = JacksonUtil.toMapsRecursion(entry.getValue().toString());
                result.put(entry.getKey(), dataMaps0);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
    }

    private static List<Map> toMapsRecursion(String data) {
        ArrayList<Map> result = new ArrayList<Map>();
        if (StringUtil.isBlank((CharSequence)data)) {
            return result;
        }
        List<Map> dataMaps = JacksonUtil.getDTOList(data);
        for (Map dataMap : dataMaps) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            JacksonUtil.toMapRecursion0(resultMap, dataMap);
            result.add(resultMap);
        }
        return result;
    }

    public static <T> T getDTO(String jsonStr, Class<T> clazz) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper();
            return (T)mapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTO(String jsonStr, Class<T> clazz, String dateFormat) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper(dateFormat);
            return (T)mapper.readValue(jsonStr, clazz);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTO(Map map, Class<T> clazz) {
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper();
            return (T)mapper.convertValue((Object)map, clazz);
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getDTO(Map map, TypeReference ref) {
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper();
            return (T)mapper.convertValue((Object)map, ref);
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Map> getDTOList(String jsonStr) {
        return JacksonUtil.getDTOList(jsonStr, Map.class);
    }

    public static <T> List<T> getDTOList(String jsonStr, Class<T> clazz) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper();
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)mapper.readValue(jsonStr, (JavaType)type);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> getDTOList(String jsonStr, Class<T> clazz, String dateFormat) {
        if (StringUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            ObjectMapper mapper = JacksonUtil.mapper(dateFormat);
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)mapper.readValue(jsonStr, (JavaType)type);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Boolean isNullJson(String str) {
        if ("{}".equals(str) || "[]".equals(str)) {
            return true;
        }
        return false;
    }
}

