/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class SpiServiceUtil {
    public static final Map<String, ServiceLoader<?>> cached = new ConcurrentHashMap();
    public static final Map<String, Object> cachedFirst = new ConcurrentHashMap<String, Object>();

    public static <S> S loadFirst(Class<S> clazz) {
        return SpiServiceUtil.loadFirst(clazz, true);
    }

    public static <S> ServiceLoader<S> loadAll(Class<S> clazz) {
        return SpiServiceUtil.loadAll(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> S loadFirst(Class<S> clazz, boolean throwException) {
        String cacheKey = clazz.getName() + ".first";
        Object cacheS = cachedFirst.get(cacheKey);
        if (cacheS != null) {
            return (S)cacheS;
        }
        Map<String, Object> map = cachedFirst;
        synchronized (map) {
            ServiceLoader<S> loader = SpiServiceUtil.loadAll(clazz);
            Iterator<S> iterator = loader.iterator();
            if (!iterator.hasNext()) {
                if (throwException) {
                    throw new IllegalStateException(String.format("No implementation defined in /META-INF/services/%s, please check whether the file exists and has the right implementation class!", clazz.getName()));
                }
                return null;
            }
            S s = iterator.next();
            cachedFirst.put(cacheKey, s);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> ServiceLoader<S> loadAll(Class<S> clazz, boolean throwException) {
        String cacheKey = clazz.getName();
        ServiceLoader<?> serviceLoader = cached.get(cacheKey);
        if (serviceLoader != null) {
            return serviceLoader;
        }
        Map<String, ServiceLoader<?>> map = cached;
        synchronized (map) {
            ServiceLoader<S> loader = ServiceLoader.load(clazz);
            Iterator<S> iterator = loader.iterator();
            if (!iterator.hasNext()) {
                if (throwException) {
                    throw new IllegalStateException(String.format("No implementation defined in /META-INF/services/%s, please check whether the file exists and has the right implementation class!", clazz.getName()));
                }
                return null;
            }
            cached.put(cacheKey, loader);
            return loader;
        }
    }
}

