/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import cn.hutool.core.date.SystemClock;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;

public class UUIDUtil {
    private static boolean isThreadlocalRandomAvailable = false;
    private static Random random;
    private static final long LEAST_SIG_BITS;
    private static final ReentrantLock lock;
    private static long lastTime;
    private static final SecureRandom secureRandom;

    private UUIDUtil() {
    }

    public static UUID random() {
        byte[] randomBytes = new byte[16];
        if (isThreadlocalRandomAvailable) {
            ThreadLocalRandom.current().nextBytes(randomBytes);
        } else {
            random.nextBytes(randomBytes);
        }
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    public static UUID create() {
        long timeMillis = SystemClock.now() * 10000L + 122192928000000000L;
        lock.lock();
        try {
            if (timeMillis > lastTime) {
                lastTime = timeMillis;
            } else {
                timeMillis = ++lastTime;
            }
        }
        finally {
            lock.unlock();
        }
        long mostSigBits = timeMillis << 32;
        mostSigBits |= (timeMillis & 0xFFFF00000000L) >> 16;
        return new UUID(mostSigBits |= 0x1000L | timeMillis >> 48 & 0xFFFL, LEAST_SIG_BITS);
    }

    public static String uuid() {
        return UUIDUtil.create().toString().replaceAll("-", "");
    }

    public static long randomLong() {
        return Math.abs(secureRandom.nextLong());
    }

    static {
        lock = new ReentrantLock();
        try {
            isThreadlocalRandomAvailable = null != UUIDUtil.class.getClassLoader().loadClass("java.util.concurrent.ThreadLocalRandom");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        byte[] seed = new SecureRandom().generateSeed(8);
        LEAST_SIG_BITS = new BigInteger(seed).longValue();
        if (!isThreadlocalRandomAvailable) {
            random = new Random(LEAST_SIG_BITS);
        }
        secureRandom = new SecureRandom();
    }
}

