/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.util.FileUtil;
import com.hy.apaas.base.core.util.XmlUtil;
import java.io.File;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(XmlUtil.class);

    private ZipUtil() {
    }

    public static void zip(String path) {
        ZipUtil.zip(path, true);
    }

    public static void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("UTF-8");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split("\\.")[0] + ".zip"));
                zipFile.setFileNameCharset("UTF-8");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir(file);
            }
        }
        catch (ZipException e) {
            logger.error("zip failed.", e.getCause());
        }
    }

    public static void zipSetPass(String path, Boolean isDelete, String password) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(password);
            File file = new File(path);
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("UTF-8");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split("\\.")[0] + ".zip"));
                zipFile.setFileNameCharset("UTF-8");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir(new File(path));
            }
        }
        catch (ZipException e) {
            logger.error("zip failed.", e.getCause());
        }
    }

    public static void unZip(String filePath, String toPath, String password) {
        try {
            ZipUtil.unZipFile(new ZipFile(filePath), toPath, password);
        }
        catch (ZipException e) {
            logger.error("unzip failed.");
        }
    }

    public static void unZipFile(ZipFile zipFile, String toPath, String password) {
        try {
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password);
            }
            List fileHeaderList = zipFile.getFileHeaders();
            for (Object o : fileHeaderList) {
                FileHeader fileHeader = (FileHeader)o;
                zipFile.extractFile(fileHeader, toPath);
            }
        }
        catch (ZipException e) {
            logger.error("unzip failed.");
        }
    }

    public static void unZipFile(String filePath, String toPath) {
        ZipUtil.unZip(filePath, toPath, "");
    }
}

