/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hy.apaas.base.core.util.EnvUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalGuavaCacheEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalGuavaCacheEngine.class);
    private static Cache<String, Cache<String, Object>> localCacheManager = CacheBuilder.newBuilder().maximumSize(64L).expireAfterAccess(30L, TimeUnit.MINUTES).removalListener(notification -> LOGGER.warn("localCacheManager -> key:{}, value:{}, \u5220\u9664\u539f\u56e0:{}", new Object[]{notification.getKey(), notification.getValue(), notification.getCause()})).build();

    public static boolean isLocalCacheEnabled(String enableKey) {
        return EnvUtil.getProperty(enableKey, Boolean.class, Boolean.valueOf(false));
    }

    public static Cache<String, Object> getOrCreateCache(String cacheName, long maximumSize, long duration, TimeUnit timeUnit) {
        Cache cache = (Cache)localCacheManager.getIfPresent((Object)cacheName);
        if (cache == null) {
            cache = CacheBuilder.newBuilder().maximumSize(maximumSize < 0L ? 10L : maximumSize).expireAfterWrite(duration < 0L ? 5L : duration, Optional.ofNullable(timeUnit).orElse(TimeUnit.MINUTES)).removalListener(notification -> LOGGER.warn("cacheName<{}> -> key:{}, value:{}, \u5220\u9664\u539f\u56e0:{}", new Object[]{cacheName, notification.getKey(), notification.getValue(), notification.getCause()})).build();
            localCacheManager.put((Object)cacheName, (Object)cache);
        }
        return cache;
    }

    public static void put(String cacheName, long maximumSize, long duration, TimeUnit timeUnit, String cacheKey, Object cacheValue) {
        Cache<String, Object> cache = LocalGuavaCacheEngine.getOrCreateCache(cacheName, maximumSize, duration, timeUnit);
        LocalGuavaCacheEngine.put(cache, cacheKey, cacheValue);
    }

    public static void put(Cache<String, Object> cache, String cacheKey, Object cacheValue) {
        if (Objects.isNull(cacheValue)) {
            return;
        }
        cache.put((Object)cacheKey, cacheValue);
    }

    public static <D> D get(String cacheName, long maximumSize, long duration, TimeUnit timeUnit, String cacheKey) {
        Cache<String, Object> cache = LocalGuavaCacheEngine.getOrCreateCache(cacheName, maximumSize, duration, timeUnit);
        return LocalGuavaCacheEngine.get(cache, cacheKey);
    }

    public static <D> D get(Cache<String, Object> cache, String cacheKey) {
        Object d;
        Object data = d = cache.getIfPresent((Object)cacheKey);
        return (D)data;
    }
}

