/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.hy.apaas.base.core.context.ThreadContext;
import com.hy.apaas.base.core.util.BeanUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultThreadContext
implements ThreadContext {
    private static final ThreadLocal<Map<String, Object>> contextLocal = new TransmittableThreadLocal();

    private Map<String, Object> getContextLocal() {
        ConcurrentHashMap contextLocalMap = null;
        if (contextLocal.get() == null) {
            contextLocalMap = new ConcurrentHashMap();
            contextLocal.set(contextLocalMap);
        }
        return contextLocal.get();
    }

    @Override
    public void cleanAll() {
        contextLocal.remove();
    }

    @Override
    public void clean(String context) {
        this.getContextLocal().remove(context);
    }

    @Override
    public Object getProperty(String context, String key) {
        if (BeanUtils.isEmpty(key)) {
            return null;
        }
        Map<String, Object> map = this.getContextMap(context);
        return map.get(key);
    }

    @Override
    public void addProperty(String context, String key, Object val) {
        if (BeanUtils.isEmpty(key) || BeanUtils.isEmpty(val)) {
            return;
        }
        Map<String, Object> map = this.getContextMap(context);
        map.put(key, val);
    }

    @Override
    public void cleanProperty(String context, String key) {
        Map<String, Object> map = this.getContextMap(context);
        map.remove(key);
    }

    @Override
    public Object getProperty(String key) {
        if (BeanUtils.isEmpty(key)) {
            return null;
        }
        Map<String, Object> propertyMap = this.getPropertyMap();
        return propertyMap.get(key);
    }

    @Override
    public void addProperty(String key, Object val) {
        if (BeanUtils.isEmpty(key) || BeanUtils.isEmpty(val)) {
            return;
        }
        Map<String, Object> propertyMap = this.getPropertyMap();
        propertyMap.put(key, val);
    }

    private Map<String, Object> getPropertyMap() {
        return this.getContextMap("context.property");
    }

    private Map<String, Object> getContextMap(String context) {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getContextLocal().get(context);
        if (null == map) {
            map = new ConcurrentHashMap();
            this.getContextLocal().put(context, map);
        }
        return map;
    }

    @Override
    public void cleanProperty(String key) {
        Map<String, Object> propertyMap = this.getPropertyMap();
        propertyMap.remove(key);
    }
}

