/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.spi.extension;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.Holder;
import com.hy.apaas.base.core.spi.extension.Adaptive;
import com.hy.apaas.base.core.spi.extension.ESPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiExtensionLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(SpiExtensionLoader.class);
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final ConcurrentMap<Class<?>, SpiExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap(64);
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap(64);
    private final Class<?> type;
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Holder<Object> cachedAdaptiveInstance = new Holder();
    private volatile Class<?> cachedAdaptiveClass = null;
    private String cachedDefaultName;
    private volatile Throwable createAdaptiveInstanceError;
    private Map<String, IllegalStateException> exceptions = new ConcurrentHashMap<String, IllegalStateException>();

    private SpiExtensionLoader(Class<?> type) {
        this.type = type;
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(ESPI.class);
    }

    public static <T> SpiExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an interface!");
        }
        if (!SpiExtensionLoader.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an extension, because it is NOT annotated with @" + ESPI.class.getSimpleName() + "!");
        }
        SpiExtensionLoader loader = (SpiExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            EXTENSION_LOADERS.putIfAbsent(type, new SpiExtensionLoader<T>(type));
            loader = (SpiExtensionLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    public String getExtensionName(T extensionInstance) {
        return this.getExtensionName(extensionInstance.getClass());
    }

    public String getExtensionName(Class<?> extensionClass) {
        this.getExtensionClasses();
        return (String)this.cachedNames.get(extensionClass);
    }

    public T getLoadedExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        return (T)holder.get();
    }

    private Holder<Object> getOrCreateHolder(String name) {
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, (Holder<Object>)new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        return holder;
    }

    public Set<String> getLoadedExtensions() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    public List<T> getLoadedExtensionInstances() {
        ArrayList instances = new ArrayList();
        this.cachedInstances.values().forEach(holder -> instances.add(holder.get()));
        return instances;
    }

    public Object getLoadedAdaptiveExtensionInstances() {
        return this.cachedAdaptiveInstance.get();
    }

    public T getExtension(String name) {
        return this.getExtension(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name, boolean wrap) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if ("true".equals(name)) {
            return this.getDefaultExtension();
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        Object instance = holder.get();
        if (instance == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name, wrap);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    public T getOrDefaultExtension(String name) {
        return this.containsExtension(name) ? this.getExtension(name) : this.getDefaultExtension();
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isBlank((CharSequence)this.cachedDefaultName) || "true".equals(this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    public boolean hasExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> c = this.getExtensionClass(name);
        return c != null;
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> clazzes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(clazzes.keySet()));
    }

    public Set<T> getSupportedExtensionInstances() {
        LinkedList<T> instances = new LinkedList<T>();
        Set<String> supportedExtensions = this.getSupportedExtensions();
        if (CollectionUtils.isNotEmpty(supportedExtensions)) {
            for (String name : supportedExtensions) {
                instances.add(this.getExtension(name));
            }
        }
        return new LinkedHashSet(instances);
    }

    public String getDefaultExtensionName() {
        this.getExtensionClasses();
        return this.cachedDefaultName;
    }

    public void addExtension(String name, Class<?> clazz) {
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + " doesn't implement the Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + " can't be interface!");
        }
        if (!clazz.isAnnotationPresent(Adaptive.class)) {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
            }
            if (((Map)this.cachedClasses.get()).containsKey(name)) {
                throw new IllegalStateException("Extension name " + name + " already exists (Extension " + this.type + ")!");
            }
            this.cachedNames.put(clazz, name);
            ((Map)this.cachedClasses.get()).put(name, clazz);
        } else {
            if (this.cachedAdaptiveClass != null) {
                throw new IllegalStateException("Adaptive Extension already exists (Extension " + this.type + ")!");
            }
            this.cachedAdaptiveClass = clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAdaptiveExtension() {
        Object instance = this.cachedAdaptiveInstance.get();
        if (instance == null) {
            if (this.createAdaptiveInstanceError != null) {
                throw new IllegalStateException("Failed to create adaptive instance: " + this.createAdaptiveInstanceError.toString(), this.createAdaptiveInstanceError);
            }
            Holder<Object> holder = this.cachedAdaptiveInstance;
            synchronized (holder) {
                instance = this.cachedAdaptiveInstance.get();
                if (instance == null) {
                    try {
                        instance = this.createAdaptiveExtension();
                        this.cachedAdaptiveInstance.set(instance);
                    }
                    catch (Throwable t) {
                        this.createAdaptiveInstanceError = t;
                        throw new IllegalStateException("Failed to create adaptive instance: " + t.toString(), t);
                    }
                }
            }
        }
        return (T)instance;
    }

    private IllegalStateException findException(String name) {
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(name.toLowerCase())) continue;
            return entry.getValue();
        }
        StringBuilder buf = new StringBuilder("No such extension " + this.type.getName() + " by name " + name);
        int i = 1;
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (i == 1) {
                buf.append(", possible causes: ");
            }
            buf.append("\r\n(");
            buf.append(i++);
            buf.append(") ");
            buf.append(entry.getKey());
            buf.append(":\r\n");
            buf.append(StringUtils.defaultString((String)ExceptionUtil.stacktraceToString((Throwable)entry.getValue())));
        }
        return new IllegalStateException(buf.toString());
    }

    private T createExtension(String name, boolean wrap) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw this.findException(name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            this.injectExtension(instance);
            if (wrap) {
                // empty if block
            }
            this.initExtension(instance);
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance (name: " + name + ", class: " + this.type + ") couldn't be instantiated: " + t.getMessage(), t);
        }
    }

    private boolean containsExtension(String name) {
        return this.getExtensionClasses().containsKey(name);
    }

    private T injectExtension(T instance) {
        return instance;
    }

    private void initExtension(T instance) {
    }

    private String getSetterProperty(Method method) {
        return method.getName().length() > 3 ? method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4) : "";
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers());
    }

    private Class<?> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        return this.getExtensionClasses().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = (Map<String, Class<?>>)this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = (Map)this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        this.cacheDefaultExtensionName();
        HashMap extensionClasses = new HashMap();
        return extensionClasses;
    }

    private void cacheDefaultExtensionName() {
        ESPI defaultAnnotation = this.type.getAnnotation(ESPI.class);
        if (defaultAnnotation == null) {
            return;
        }
        String value = defaultAnnotation.value();
        if ((value = value.trim()).length() > 0) {
            Object[] names = NAME_SEPARATOR.split(value);
            if (names.length > 1) {
                throw new IllegalStateException("More than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
            }
            if (names.length == 1) {
                this.cachedDefaultName = names[0];
            }
        }
    }

    private void loadDirectory(Map<String, Class<?>> extensionClasses, String dir, String type) {
        this.loadDirectory(extensionClasses, dir, type, false, false, new String[0]);
    }

    private static ClassLoader findClassLoader() {
        return SpiExtensionLoader.getClassLoader(SpiExtensionLoader.class);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = clazz.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private void loadDirectory(Map<String, Class<?>> extensionClasses, String dir, String type, boolean extensionLoaderClassLoaderFirst, boolean overridden, String ... excludedPackages) {
        String fileName = dir + type;
        try {
            Enumeration<URL> urls = null;
            ClassLoader classLoader = SpiExtensionLoader.findClassLoader();
            if (extensionLoaderClassLoaderFirst) {
                ClassLoader extensionLoaderClassLoader = SpiExtensionLoader.class.getClassLoader();
                if (ClassLoader.getSystemClassLoader() != extensionLoaderClassLoader) {
                    urls = extensionLoaderClassLoader.getResources(fileName);
                }
            }
            if (urls == null || !urls.hasMoreElements()) {
                urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            }
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL resourceURL = urls.nextElement();
                    this.loadResource(extensionClasses, classLoader, resourceURL, overridden, excludedPackages);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Exception occurred when loading extension class (interface: " + type + ", description file: " + fileName + ").", t);
        }
    }

    private void loadResource(Map<String, Class<?>> extensionClasses, ClassLoader classLoader, URL resourceURL, boolean overridden, String ... excludedPackages) {
        block20: {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int ci = line.indexOf(35);
                            if (ci >= 0) {
                                line = line.substring(0, ci);
                            }
                            if ((line = line.trim()).length() <= 0) continue;
                            try {
                                String name = null;
                                int i = line.indexOf(61);
                                if (i > 0) {
                                    name = line.substring(0, i).trim();
                                    line = line.substring(i + 1).trim();
                                }
                                if (line.length() <= 0 || this.isExcluded(line, excludedPackages)) continue block13;
                                this.loadClass(extensionClasses, resourceURL, Class.forName(line, true, classLoader), name, overridden);
                                continue block13;
                            }
                            catch (Throwable t) {
                                IllegalStateException e = new IllegalStateException("Failed to load extension class (interface: " + this.type + ", class line: " + line + ") in " + resourceURL + ", cause: " + t.getMessage(), t);
                                this.exceptions.put(line, e);
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Exception occurred when loading extension class (interface: " + this.type + ", class file: " + resourceURL + ") in " + resourceURL, t);
            }
        }
    }

    private boolean isExcluded(String className, String ... excludedPackages) {
        if (excludedPackages != null) {
            for (String excludePackage : excludedPackages) {
                if (!className.startsWith(excludePackage + ".")) continue;
                return true;
            }
        }
        return false;
    }

    private void loadClass(Map<String, Class<?>> extensionClasses, URL resourceURL, Class<?> clazz, String name, boolean overridden) throws NoSuchMethodException {
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Error occurred when loading extension class (interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + " is not subtype of interface.");
        }
        if (clazz.isAnnotationPresent(Adaptive.class)) {
            this.cacheAdaptiveClass(clazz, overridden);
        } else {
            clazz.getConstructor(new Class[0]);
            if (StringUtils.isEmpty((CharSequence)name) && (name = this.findAnnotationName(clazz)).length() == 0) {
                throw new IllegalStateException("No such extension name for the class " + clazz.getName() + " in the config " + resourceURL);
            }
            Object[] names = NAME_SEPARATOR.split(name);
            if (ArrayUtils.isNotEmpty((Object[])names)) {
                for (Object n : names) {
                    this.cacheName(clazz, (String)n);
                    this.saveInExtensionClass(extensionClasses, clazz, (String)n, overridden);
                }
            }
        }
    }

    private String findAnnotationName(Class<?> clazz) {
        ESPI extension = clazz.getAnnotation(ESPI.class);
        if (extension != null) {
            return extension.value();
        }
        String name = clazz.getSimpleName();
        if (name.endsWith(this.type.getSimpleName())) {
            name = name.substring(0, name.length() - this.type.getSimpleName().length());
        }
        return name.toLowerCase();
    }

    private void cacheName(Class<?> clazz, String name) {
        if (!this.cachedNames.containsKey(clazz)) {
            this.cachedNames.put(clazz, name);
        }
    }

    private void saveInExtensionClass(Map<String, Class<?>> extensionClasses, Class<?> clazz, String name, boolean overridden) {
        Class<?> c = extensionClasses.get(name);
        if (c == null || overridden) {
            extensionClasses.put(name, clazz);
        } else if (c != clazz) {
            String duplicateMsg = "Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName();
            logger.error(duplicateMsg);
            throw new IllegalStateException(duplicateMsg);
        }
    }

    private void cacheAdaptiveClass(Class<?> clazz, boolean overridden) {
        if (this.cachedAdaptiveClass == null || overridden) {
            this.cachedAdaptiveClass = clazz;
        } else if (!this.cachedAdaptiveClass.equals(clazz)) {
            throw new IllegalStateException("More than 1 adaptive class found: " + this.cachedAdaptiveClass.getName() + ", " + clazz.getName());
        }
    }

    private T createAdaptiveExtension() {
        try {
            return (T)this.injectExtension(this.getAdaptiveExtensionClass().newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't create adaptive extension " + this.type + ", cause: " + e.getMessage(), e);
        }
    }

    private Class<?> getAdaptiveExtensionClass() {
        this.getExtensionClasses();
        if (this.cachedAdaptiveClass != null) {
            return this.cachedAdaptiveClass;
        }
        this.cachedAdaptiveClass = this.createAdaptiveExtensionClass();
        return this.cachedAdaptiveClass;
    }

    private Class<?> createAdaptiveExtensionClass() {
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }
}

