/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayUtil
extends ArrayUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayUtil.class);

    public static Long[] convertArray(String[] aryStr) {
        if (ArrayUtils.isEmpty((Object[])aryStr)) {
            return ArrayUtils.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] aryLong = new Long[aryStr.length];
        for (int i = 0; i < aryStr.length; ++i) {
            aryLong[i] = Long.parseLong(aryStr[i]);
        }
        return aryLong;
    }

    public static String[] convertArray(Long[] aryLong) {
        if (ArrayUtils.isEmpty((Object[])aryLong)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] aryStr = new String[aryLong.length];
        for (int i = 0; i < aryStr.length; ++i) {
            aryStr[i] = String.valueOf(aryStr[i]);
        }
        return aryStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T[] deepCopy(T[] src) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ByteArrayInputStream byteIn = null;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object[] dest = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            in = new ObjectInputStream(byteIn);
            dest = (Object[])in.readObject();
        }
        catch (IOException e) {
            LOGGER.error("clone object failed {}.", (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("class not found {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return dest;
    }
}

