/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static void writeFile(String fileName, String content) {
        FileUtil.writeFile(fileName, content, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String content, String charset) {
        Writer out = null;
        try {
            FileUtil.createFolder(fileName, true);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset));
            out.write(content);
        }
        catch (IOException e) {
            logger.error("write file failed {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream is, String charset, boolean isLine) {
        BufferedReader in = null;
        try {
            String str;
            StringBuilder content = new StringBuilder();
            in = new BufferedReader(new InputStreamReader(is, charset));
            while ((str = in.readLine()) != null) {
                content.append(str + (isLine ? "\r\n" : ""));
            }
            String string = content.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeFile(String fileName, InputStream is) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(fileName);
            byte[] bs = new byte[512];
            int n = 0;
            while ((n = is.read(bs)) != -1) {
                fos.write(bs, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filePath, String charset, boolean isLine) {
        BufferedReader in = null;
        try {
            String str;
            StringBuilder content = new StringBuilder();
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), charset));
            while ((str = in.readLine()) != null) {
                content.append(str + (isLine ? "\r\n" : ""));
            }
            String string = content.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String readFile(String filePath, String charset) {
        return FileUtil.readFile(filePath, charset, true);
    }

    public static String readFile(String filePath) {
        try {
            File file = new File(filePath);
            String charset = FileUtil.getCharset(file);
            return FileUtil.readFile(filePath, charset);
        }
        catch (Exception e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
            return "";
        }
    }

    public static String readByClassPath(String filePath) {
        return FileUtil.readByClassPath(filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readByClassPath(String filePath, ClassLoader classLoader) {
        BufferedReader br = null;
        try {
            URL url = null;
            url = classLoader != null ? classLoader.getResource("/" + filePath) : FileUtil.class.getResource("/" + filePath);
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            String s = null;
            StringBuilder fileText = new StringBuilder();
            while ((s = br.readLine()) != null) {
                fileText.append(s).append("\r\n");
            }
            String string = fileText.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isExistFile(String dir) {
        boolean isExist = false;
        File fileDir = new File(dir);
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            if (files != null && files.length != 0) {
                isExist = true;
            }
        } else {
            isExist = fileDir.exists();
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCharset(File file) {
        String charset;
        block30: {
            charset = "GBK";
            byte[] first3Bytes = new byte[3];
            BufferedInputStream bis = null;
            try {
                boolean checked = false;
                bis = new BufferedInputStream(new FileInputStream(file));
                bis.mark(0);
                int read = bis.read(first3Bytes, 0, 3);
                if (read == -1) {
                    String string = charset;
                    return string;
                }
                if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                    charset = "UTF-16LE";
                    checked = true;
                } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                    charset = "UTF-16BE";
                    checked = true;
                } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                    charset = "UTF-8";
                    checked = true;
                }
                bis.reset();
                if (checked) break block30;
                while ((read = bis.read()) != -1) {
                    if (read >= 240) {
                    } else if (128 <= read && read <= 191) {
                    } else if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 <= read && read <= 191) {
                            continue;
                        }
                    } else {
                        if (224 > read || read > 239) continue;
                        read = bis.read();
                        if (128 <= read && read <= 191 && 128 <= (read = bis.read()) && read <= 191) {
                            charset = "UTF-8";
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("read file failed {}.", (Object)e.getMessage());
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return charset;
    }

    public static byte[] readByte(InputStream is) {
        try {
            byte[] r = new byte[is.available()];
            is.read(r);
            return r;
        }
        catch (Exception e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByte(String fileName) {
        ByteArrayOutputStream out = null;
        FileInputStream fis = null;
        try {
            out = new ByteArrayOutputStream();
            fis = new FileInputStream(fileName);
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = fis.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeByte(String fileName, byte[] b) {
        FilterOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(fileName));
            fos.write(b);
            fos.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("write file failed {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeToFile(Object obj, String fileName) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(fileName));
            out.writeObject(obj);
        }
        catch (IOException e) {
            logger.error("serialize to file failed {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeFromFile(String fileName) {
        ObjectInputStream in = null;
        try {
            File file = new File(fileName);
            in = new ObjectInputStream(new FileInputStream(file));
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            logger.error("deserialize from file failed {}.", (Object)e.getMessage());
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String inputStream2String(InputStream input, String charset) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input, charset));
        StringBuilder builder = new StringBuilder();
        String line = "";
        while ((line = in.readLine()) != null) {
            builder.append(line + "\n");
        }
        return builder.toString();
    }

    public static String inputStream2String(InputStream input) throws IOException {
        return FileUtil.inputStream2String(input, "UTF-8");
    }

    public static File[] getFiles(String path) {
        File file = new File(path);
        return file.listFiles();
    }

    public static String createFile(String filePath, String fileName) {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getPath() + File.separator + fileName;
    }

    public static void createFolderFile(String path) {
        FileUtil.createFolder(path, true);
    }

    public static void createFolder(String path, boolean isFile) {
        File file;
        if (isFile) {
            path = path.substring(0, path.lastIndexOf(File.separator));
        }
        if (!(file = new File(path)).exists()) {
            file.mkdirs();
        }
    }

    public static boolean renameFolder(String path, String newName) {
        File file = new File(path);
        boolean result = false;
        if (file.exists()) {
            result = file.renameTo(new File(newName));
        }
        return result;
    }

    public static List<File> getDiretoryOnly(File dir) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (dir != null && dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            for (int i = 0; i < files.length; ++i) {
                dirs.add(files[i]);
            }
        }
        return dirs;
    }

    public List<File> getFileOnly(File dir) {
        ArrayList<File> dirs = new ArrayList<File>();
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        for (int i = 0; i < files.length; ++i) {
            dirs.add(files[i]);
        }
        return dirs;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean copyFile(String from, String to, boolean autoCreate) {
        fromFile = new File(from);
        if (!fromFile.exists() || fromFile.isDirectory()) {
            FileUtil.logger.error("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u662f\u76ee\u5f55\uff01");
            return false;
        }
        toFile = new File(to);
        result = false;
        if (toFile.exists()) ** GOTO lbl20
        if (autoCreate) {
            toParentFile = toFile.getParentFile();
            result = toParentFile.mkdirs();
            try {
                if (!result) ** GOTO lbl36
                result = toFile.createNewFile();
            }
            catch (IOException e) {
                FileUtil.logger.error("create file failed {}.", (Object)e.getMessage());
                return false;
            }
        } else {
            FileUtil.logger.error("\u76ee\u6807\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return false;
lbl20:
            // 1 sources

            if (toFile.isDirectory()) {
                FileUtil.logger.error("\u76ee\u6807\u6587\u4ef6\u662f\u76ee\u5f55\uff01");
                return false;
            }
            if (toFile.isFile()) {
                if (autoCreate) {
                    try {
                        result = toFile.delete();
                        if (!result) ** GOTO lbl36
                        result = toFile.createNewFile();
                    }
                    catch (IOException e) {
                        FileUtil.logger.error("create file failed {}.", (Object)e.getMessage());
                        return false;
                    }
                }
            } else {
                FileUtil.logger.error("unknow exception.");
                return false;
            }
        }
lbl36:
        // 5 sources

        if (!result) {
            return false;
        }
        return FileUtil.copy(fromFile, toFile);
    }

    public static boolean copyFile(String from, String to) {
        File fromFile = new File(from);
        if (!fromFile.exists() || fromFile.isDirectory()) {
            logger.error("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u662f\u76ee\u5f55\uff01");
            return false;
        }
        File toFile = new File(to);
        return FileUtil.copy(fromFile, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy(File fromFile, File toFile) {
        FileInputStream fis = null;
        OutputStream fos = null;
        try {
            int bytesRead;
            fis = new FileInputStream(fromFile);
            fos = new FileOutputStream(toFile);
            byte[] buf = new byte[4096];
            while ((bytesRead = fis.read(buf)) != -1) {
                ((FileOutputStream)fos).write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            logger.error("copy file failed {}.", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != fos) {
                    fos.flush();
                }
                if (null != fos) {
                    ((FileOutputStream)fos).close();
                }
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void backupFile(String filePath) {
        String backupName = filePath + ".bak";
        File file = new File(backupName);
        boolean result = false;
        if (file.exists()) {
            result = file.delete();
        }
        if (result) {
            FileUtil.copyFile(filePath, backupName);
        }
    }

    public static String getFileExt(File file) {
        if (file.isFile()) {
            return FileUtil.getFileExt(file.getName());
        }
        return "";
    }

    public static String getFileExt(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos > -1) {
            return fileName.substring(pos + 1).toLowerCase();
        }
        return "";
    }

    public static void copyDir(String fromDir, String toDir) throws IOException {
        new File(toDir).mkdirs();
        File[] file = new File(fromDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                String fromFile = file[i].getAbsolutePath();
                String toFile = toDir + "/" + file[i].getName();
                FileUtil.copyFile(fromFile, toFile);
            }
            if (!file[i].isDirectory()) continue;
            FileUtil.copyDirectiory(fromDir + "/" + file[i].getName(), toDir + "/" + file[i].getName());
        }
    }

    private static void copyDirectiory(String fromDir, String toDir) throws IOException {
        new File(toDir).mkdirs();
        File[] file = new File(fromDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                String fromName = file[i].getAbsolutePath();
                String toFile = toDir + File.separator + file[i].getName();
                FileUtil.copyFile(fromName, toFile);
            }
            if (!file[i].isDirectory()) continue;
            FileUtil.copyDirectiory(fromDir + File.separator + file[i].getName(), toDir + File.separator + file[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSize(File file) throws IOException {
        if (file.isFile()) {
            int size = 0;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                size = fis.available();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e.getCause());
            }
            finally {
                if (null != fis) {
                    fis.close();
                }
            }
            return FileUtil.getSize(size);
        }
        return "";
    }

    public static String getSize(double size) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (size > 1048576.0) {
            double ss = size / 1048576.0;
            return df.format(ss) + " M";
        }
        if (size > 1024.0) {
            double ss = size / 1024.0;
            return df.format(ss) + " KB";
        }
        return size + " bytes";
    }

    public static String getParentDir(String baseDir, String currentFile) {
        File f = new File(currentFile);
        String parentPath = f.getParent();
        String path = parentPath.replace(baseDir, "");
        return path.replace(File.separator, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromProperties(String fileName, String key) {
        String value = "";
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(fileName));
            Properties prop = new Properties();
            prop.load(stream);
            value = prop.getProperty(key);
        }
        catch (Exception e) {
            logger.error("read file failed {}.", (Object)e.getMessage());
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveProperties(String fileName, String key, String value) {
        StringBuilder tempProp = new StringBuilder();
        boolean isFound = false;
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            while ((str = in.readLine()) != null) {
                if (str.startsWith(key)) {
                    tempProp.append(key + "=" + value + "\r\n");
                    isFound = true;
                    continue;
                }
                tempProp.append(str + "\r\n");
            }
            if (!isFound) {
                tempProp.append(key + "=" + value + "\r\n");
            }
            FileUtil.writeFile(fileName, tempProp.toString(), "UTF-8");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("write properties failed {}.", (Object)ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delProperties(String fileName, String key) {
        StringBuilder tempProp = new StringBuilder();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
            while ((str = in.readLine()) != null) {
                if (str.startsWith(key)) continue;
                tempProp.append(str + "\r\n");
            }
            FileUtil.writeFile(fileName, tempProp.toString(), "utf-8");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("write properties failed {}.", (Object)ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static List<Class<?>> getAllClassesByInterface(Class<?> interfaceClass, boolean samePackage) throws IOException, ClassNotFoundException {
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("Class not a interface.");
        }
        ClassLoader loader = interfaceClass.getClassLoader();
        String packageName = samePackage ? interfaceClass.getPackage().getName() : "/";
        return FileUtil.findClasses(interfaceClass, loader, packageName);
    }

    private static List<Class<?>> findClasses(Class<?> interfaceClass, ClassLoader loader, String packageName) throws IOException, ClassNotFoundException {
        ArrayList allClasses = new ArrayList();
        String packagePath = packageName.replace(".", "/");
        if (!packagePath.equals("/")) {
            Enumeration<URL> resources = loader.getResources(packagePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                allClasses.addAll(FileUtil.findResources(interfaceClass, new File(url.getFile()), packageName));
            }
        } else {
            String path = loader.getResource("").getPath();
            allClasses.addAll(FileUtil.findResources(interfaceClass, new File(path), packageName));
        }
        return allClasses;
    }

    private static List<Class<?>> findResources(Class<?> interfaceClass, File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList results = new ArrayList();
        if (!directory.exists()) {
            return Collections.emptyList();
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains(".")) continue;
                if (!packageName.equals("/")) {
                    results.addAll(FileUtil.findResources(interfaceClass, file, packageName + "." + file.getName()));
                    continue;
                }
                results.addAll(FileUtil.findResources(interfaceClass, file, file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            Class<?> clazz = null;
            clazz = !packageName.equals("/") ? Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)) : Class.forName(file.getName().substring(0, file.getName().length() - 6));
            if (!interfaceClass.isAssignableFrom(clazz) || interfaceClass.equals(clazz)) continue;
            results.add(clazz);
        }
        return results;
    }

    public static String getClassesPath() {
        String path = FileUtil.class.getClassLoader().getResource("").getPath();
        if ("\\".equals(File.separator)) {
            path = StringUtil.trimPrefix(path, "/");
        }
        path = path.replace("\\", "/");
        path = StringUtil.trimSuffix(path, "/");
        return path.replaceAll("%20", " ");
    }

    public static String getWebRootPath() {
        String path = FileUtil.getClassesPath();
        path = path.substring(0, path.lastIndexOf("WEB-INF"));
        path = StringUtil.trimSuffix(path, "/");
        return path;
    }

    public static String pathJoin(String[] path) {
        int j;
        StringBuilder pathBuilder = new StringBuilder();
        int n = j = path == null ? 0 : path.length;
        for (int i = 0; i < j; ++i) {
            String str = path[i];
            if (str == null) {
                str = "";
            }
            if (i > 0 && (str.startsWith("/") || str.startsWith("\\"))) {
                str = str.substring(1);
            }
            pathBuilder.append(str);
            if (i + 1 >= j || str.endsWith("/") || str.endsWith("\\")) continue;
            pathBuilder.append("/");
        }
        return pathBuilder.toString();
    }

    public static File[] list2Array(List<File> files) {
        File[] rs = null;
        if (BeanUtils.isEmpty(files)) {
            return rs;
        }
        rs = new File[files.size()];
        int len = files.size();
        for (int i = 0; i < len; ++i) {
            rs[i] = files.get(i);
        }
        return rs;
    }

    public static List<File> list(String path, String endWith) {
        return FileUtil.list(path, endWith, -1);
    }

    public static List<File> list(String path, final String endWith, int level) {
        ArrayList<File> rsList;
        block15: {
            File[] tempRsFiles;
            File[] rsFiles;
            List<File> tempRsList;
            File parent;
            block16: {
                block13: {
                    File[] tempRsFiles2;
                    block14: {
                        if (level == 0) {
                            return Collections.emptyList();
                        }
                        if (StringUtil.isBlank((CharSequence)path)) {
                            return Collections.emptyList();
                        }
                        parent = new File(path);
                        if (!parent.exists()) {
                            return Collections.emptyList();
                        }
                        if (parent.isFile()) {
                            return Collections.emptyList();
                        }
                        rsList = new ArrayList<File>();
                        tempRsList = null;
                        rsFiles = null;
                        if (level >= 0) break block13;
                        if (!"*".equals(endWith)) break block14;
                        rsFiles = parent.listFiles();
                        if (!BeanUtils.isNotEmpty(rsFiles)) break block15;
                        for (File file : rsFiles) {
                            if (file.isFile()) {
                                rsList.add(file);
                                continue;
                            }
                            tempRsList = FileUtil.list(file.getAbsolutePath(), endWith, -1);
                            if (!BeanUtils.isNotEmpty(tempRsList)) continue;
                            rsList.addAll(tempRsList);
                        }
                        break block15;
                    }
                    rsFiles = parent.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().endsWith(endWith);
                        }
                    });
                    if (BeanUtils.isNotEmpty(rsFiles)) {
                        rsList.addAll(Arrays.asList(rsFiles));
                    }
                    if (!BeanUtils.isNotEmpty(tempRsFiles2 = parent.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    }))) break block15;
                    for (File file : tempRsFiles2) {
                        tempRsList = FileUtil.list(file.getAbsolutePath(), endWith, -1);
                        if (!BeanUtils.isNotEmpty(tempRsList)) continue;
                        rsList.addAll(tempRsList);
                    }
                    break block15;
                }
                if (!"*".equals(endWith)) break block16;
                rsFiles = parent.listFiles();
                if (!BeanUtils.isNotEmpty(rsFiles)) break block15;
                for (File file : rsFiles) {
                    if (file.isFile()) {
                        rsList.add(file);
                        continue;
                    }
                    tempRsList = FileUtil.list(file.getAbsolutePath(), endWith, level - 1);
                    if (!BeanUtils.isNotEmpty(tempRsList)) continue;
                    rsList.addAll(tempRsList);
                }
                break block15;
            }
            rsFiles = parent.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(endWith);
                }
            });
            if (BeanUtils.isNotEmpty(rsFiles)) {
                rsList.addAll(Arrays.asList(rsFiles));
            }
            if (BeanUtils.isNotEmpty(tempRsFiles = parent.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            }))) {
                for (File file : tempRsFiles) {
                    tempRsList = FileUtil.list(file.getAbsolutePath(), endWith, level - 1);
                    if (!BeanUtils.isNotEmpty(tempRsList)) continue;
                    rsList.addAll(tempRsList);
                }
            }
        }
        return rsList;
    }

    public static String getJarFiles(String baseJarDir) {
        String splt;
        File sourceFile = new File(baseJarDir);
        final StringBuilder jars = new StringBuilder();
        String osName = System.getProperty("os.name").toLowerCase();
        String string = splt = osName.contains("win") ? ";" : ":";
        if (sourceFile.exists() && sourceFile.isDirectory()) {
            sourceFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        jars.append(FileUtil.getJarFiles(pathname.getPath()));
                        return true;
                    }
                    String name = pathname.getName();
                    if (name.endsWith(".jar")) {
                        jars.append(pathname.getPath()).append(splt);
                        return true;
                    }
                    return false;
                }
            });
        }
        return jars.toString();
    }

    public static String getExtensionName(String fileName) {
        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        return prefix;
    }

    public static String getOriginalFilename(String filename) {
        if (filename == null) {
            return "";
        }
        int pos = filename.lastIndexOf("/");
        if (pos == -1) {
            pos = filename.lastIndexOf("\\");
        }
        if (pos != -1) {
            return filename.substring(pos + 1);
        }
        return filename;
    }
}

