/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.gson.BooleanSerializer;
import com.hy.apaas.base.core.util.gson.DateSerializer;
import com.hy.apaas.base.core.util.gson.JsonObjectSerializer;
import com.hy.apaas.base.core.util.gson.SqlDateSerializer;
import com.hy.apaas.base.core.util.gson.SuperclassExclusionStrategy;
import com.hy.apaas.base.core.util.gson.TimestampSerializer;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GsonUtil {
    private static Logger logger = LoggerFactory.getLogger(GsonUtil.class);

    private GsonUtil() {
    }

    private static Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(String.class, (Object)new JsonObjectSerializer()).registerTypeAdapter(java.util.Date.class, (Object)new DateSerializer()).registerTypeAdapter(Timestamp.class, (Object)new TimestampSerializer()).registerTypeAdapter(Date.class, (Object)new SqlDateSerializer()).registerTypeAdapter(Boolean.class, (Object)new BooleanSerializer()).addDeserializationExclusionStrategy((ExclusionStrategy)new SuperclassExclusionStrategy()).addSerializationExclusionStrategy((ExclusionStrategy)new SuperclassExclusionStrategy());
        return gsonBuilder.create();
    }

    private static Gson getGson(String dateFormat) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(String.class, (Object)new JsonObjectSerializer()).registerTypeAdapter(java.util.Date.class, (Object)new DateSerializer(dateFormat)).registerTypeAdapter(Timestamp.class, (Object)new TimestampSerializer(dateFormat)).registerTypeAdapter(Date.class, (Object)new SqlDateSerializer(dateFormat)).registerTypeAdapter(Boolean.class, (Object)new BooleanSerializer()).addDeserializationExclusionStrategy((ExclusionStrategy)new SuperclassExclusionStrategy()).addSerializationExclusionStrategy((ExclusionStrategy)new SuperclassExclusionStrategy());
        return gsonBuilder.create();
    }

    public static boolean isEmpty(Object o) {
        if (BeanUtils.isEmpty(o)) {
            return true;
        }
        if (o instanceof JsonObject) {
            return ((JsonObject)o).isJsonNull();
        }
        if (o instanceof JsonArray) {
            return ((JsonArray)o).isJsonNull();
        }
        if (o instanceof JsonNull) {
            return true;
        }
        return JsonNull.INSTANCE.equals(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !GsonUtil.isEmpty(o);
    }

    public static boolean isNotJson(String jsonString) {
        return !GsonUtil.isJson(jsonString);
    }

    public static boolean isJson(String jsonStr) {
        return GsonUtil.isJsonObject(jsonStr) || GsonUtil.isJsonArray(jsonStr);
    }

    public static boolean isJsonObject(String jsonStr) {
        if (GsonUtil.isEmpty(jsonStr)) {
            return false;
        }
        try {
            JsonElement jElement = new JsonParser().parse(jsonStr);
            return jElement.isJsonObject();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNotJsonObject(String jsonStr) {
        return !GsonUtil.isJsonObject(jsonStr);
    }

    public static boolean isJsonArray(String jsonStr) {
        if (GsonUtil.isEmpty(jsonStr)) {
            return false;
        }
        try {
            JsonElement jElement = new JsonParser().parse(jsonStr);
            return jElement.isJsonArray();
        }
        catch (Exception ee) {
            return false;
        }
    }

    public static boolean isNotJsonArray(String jsonStr) {
        return !GsonUtil.isJsonArray(jsonStr);
    }

    public static String getString(JsonObject obj, String key, String defaultValue) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        return obj.get(key).getAsString();
    }

    public static String getString(JsonObject obj, String key) {
        return GsonUtil.getString(obj, key, "");
    }

    public static long getLong(JsonObject obj, String key) {
        return GsonUtil.getLong(obj, key, 0L);
    }

    public static long getLong(JsonObject obj, String key, long defaultValue) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        try {
            return obj.get(key).getAsLong();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static int getInt(JsonObject obj, String key) {
        return GsonUtil.getInt(obj, key, 0);
    }

    public static int getInt(JsonObject obj, String key, int defaultValue) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        try {
            return obj.get(key).getAsInt();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBool(JsonObject o, String key) {
        return GsonUtil.getBool(o, key, false);
    }

    public static boolean getBool(JsonObject o, String key, boolean defaultValue) {
        if (!o.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(o.get(key))) {
            return defaultValue;
        }
        try {
            JsonElement obj = o.get(key);
            if (obj != null) {
                if (obj.equals(Boolean.FALSE) || obj instanceof String && ((String)obj).equalsIgnoreCase("N") || obj instanceof Integer && (Integer)obj == 0) {
                    return false;
                }
                if (obj.equals(Boolean.TRUE) || obj instanceof String && ((String)obj).equalsIgnoreCase("Y") || obj instanceof Integer && (Integer)obj == 1) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return defaultValue;
    }

    public static boolean getBoolean(JsonObject o, String key) {
        return GsonUtil.getBoolean(o, key, false);
    }

    public static boolean getBoolean(JsonObject o, String key, boolean defaultValue) {
        if (!o.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(o.get(key))) {
            return defaultValue;
        }
        try {
            return o.get(key).getAsBoolean();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static char getChar(JsonObject obj, String key) {
        return GsonUtil.getChar(obj, key, 'Y');
    }

    public static char getChar(JsonObject obj, String key, char defaultValue) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        String v = obj.get(key).getAsString();
        char[] c = v.toCharArray();
        if (c.length == 0) {
            return defaultValue;
        }
        return v.toCharArray()[0];
    }

    public static float getFloat(JsonObject obj, String key) {
        return GsonUtil.getFloat(obj, key, 0.0f);
    }

    public static float getFloat(JsonObject obj, String key, float defaultValue) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        JsonElement v = obj.get(key);
        return Float.valueOf(v.toString()).floatValue();
    }

    public static double getDouble(JsonObject obj, String key) {
        return GsonUtil.getDouble(obj, key, 0.0);
    }

    public static double getDouble(JsonObject obj, String key, double defaultValue) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        if (GsonUtil.isEmpty(obj.get(key))) {
            return defaultValue;
        }
        JsonElement v = obj.get(key);
        return Double.valueOf(v.toString());
    }

    public static JsonArray getJsonArray(JsonObject obj, String key) {
        JsonElement json = obj.get(key);
        if (GsonUtil.isEmpty(json)) {
            return null;
        }
        return json.getAsJsonArray();
    }

    public static JsonObject getJsonObject(JsonObject obj, String key) {
        JsonElement json = obj.get(key);
        if (GsonUtil.isEmpty(json)) {
            return null;
        }
        return json.getAsJsonObject();
    }

    public static String toJsonString(Object obj) {
        return GsonUtil.getGson().toJson(obj);
    }

    public static String toJsonString(Object obj, String dateFormat) {
        return GsonUtil.getGson(dateFormat).toJson(obj);
    }

    public static JsonObject toJsonObject(Object obj) {
        JsonElement parser = new JsonParser().parse(GsonUtil.getGson().toJson(obj));
        return parser.getAsJsonObject();
    }

    public static JsonArray toJsonArray(List<?> obj) {
        JsonElement parser = new JsonParser().parse(GsonUtil.getGson().toJson(obj));
        return parser.getAsJsonArray();
    }

    public static JsonArray toJsonArray(Object[] obj) {
        JsonElement parser = new JsonParser().parse(GsonUtil.getGson().toJson((Object)obj));
        return parser.getAsJsonArray();
    }

    public static JsonArray toJsonArray(Object obj) {
        JsonElement parser = new JsonParser().parse(GsonUtil.getGson().toJson(obj));
        return parser.getAsJsonArray();
    }

    public static <C> C toBean(String jsonStr, Class<C> cls) {
        if (cls.equals(String.class)) {
            return (C)jsonStr;
        }
        return (C)GsonUtil.getGson().fromJson(jsonStr, cls);
    }

    public static <C> C toBean(String jsonStr, Type type) {
        return (C)GsonUtil.getGson().fromJson(jsonStr, type);
    }

    public static JsonElement toJsonTree(Object obj) {
        return GsonUtil.getGson().toJsonTree(obj);
    }

    public static <C> C getValue(String jsonStr, String key, Object defaultVal, Class<C> cls) {
        JsonElement jElement = new JsonParser().parse(jsonStr);
        if (jElement.isJsonObject()) {
            JsonObject jobject = jElement.getAsJsonObject();
            JsonElement element = jobject.get(key);
            if (BeanUtils.isEmpty(element)) {
                if (defaultVal != null) {
                    return GsonUtil.toBean(defaultVal.toString(), cls);
                }
                return null;
            }
            if (String.class.equals(cls)) {
                return (C)element.getAsString();
            }
            return GsonUtil.toBean(element.getAsString(), cls);
        }
        return null;
    }

    public static <T> List<T> getDTOList(String jsonStr, Class<T> clazz) {
        JsonElement jElement = new JsonParser().parse(jsonStr);
        if (jElement.isJsonArray()) {
            JsonArray array = jElement.getAsJsonArray();
            ArrayList<T> list = new ArrayList<T>();
            for (JsonElement jsonElement : array) {
                list.add(GsonUtil.getDTO(jsonElement.getAsString(), clazz));
            }
            return list;
        }
        return null;
    }

    public static <T> T getDTO(String jsonStr, Class<T> clazz) {
        return (T)GsonUtil.getGson().fromJson(jsonStr, clazz);
    }

    public static Map<String, Object> getMapFromJson(String jsonString) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (GsonUtil.isEmpty(jsonString)) {
            return map;
        }
        JsonObject jsonObject = GsonUtil.toJsonObject(jsonString);
        for (Map.Entry key : jsonObject.entrySet()) {
            map.put((String)key.getKey(), key.getValue());
        }
        return map;
    }

    public static Map getMapFromJson(String jsonString, Class clazz) {
        HashMap map = new HashMap();
        if (GsonUtil.isEmpty(jsonString)) {
            return map;
        }
        JsonObject jsonObject = GsonUtil.toJsonObject(jsonString);
        for (Map.Entry key : jsonObject.entrySet()) {
            if (key.getValue() == null) continue;
            List list = GsonUtil.getDTOList(((JsonElement)key.getValue()).getAsString(), clazz);
            map.put(key.getKey(), list);
        }
        return map;
    }

    public static <C> C toBean(String jsonStr, Class<C> cls, String dateFormat) {
        if (cls.equals(String.class)) {
            return (C)jsonStr;
        }
        return (C)GsonUtil.getGson(dateFormat).fromJson(jsonStr, cls);
    }

    public static <C> C toBean(String jsonStr, Type type, String dateFormat) {
        return (C)GsonUtil.getGson(dateFormat).fromJson(jsonStr, type);
    }

    public static JsonElement toJsonTree(Object obj, String dateFormat) {
        return GsonUtil.getGson(dateFormat).toJsonTree(obj);
    }

    public static <C> C getValue(String jsonStr, String key, Object defaultVal, Class<C> cls, String dateFormat) {
        JsonElement jElement = new JsonParser().parse(jsonStr);
        if (jElement.isJsonObject()) {
            JsonObject jobject = jElement.getAsJsonObject();
            JsonElement element = jobject.get(key);
            if (BeanUtils.isEmpty(element)) {
                if (defaultVal != null) {
                    return GsonUtil.toBean(defaultVal.toString(), cls, dateFormat);
                }
                return null;
            }
            if (String.class.equals(cls)) {
                return (C)element.getAsString();
            }
            return GsonUtil.toBean(element.getAsString(), cls, dateFormat);
        }
        return null;
    }

    public static <T> List<T> getDTOList(String jsonStr, Class<T> clazz, String dateFormat) {
        JsonElement jElement = new JsonParser().parse(jsonStr);
        if (jElement.isJsonArray()) {
            JsonArray array = jElement.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement jsonElement : array) {
                list.add(GsonUtil.getGson(dateFormat).fromJson(jsonElement, clazz));
            }
            return list;
        }
        return null;
    }

    public static <T> T getDTO(String jsonStr, Class<T> clazz, String dateFormat) {
        return (T)GsonUtil.getGson(dateFormat).fromJson(jsonStr, clazz);
    }

    public static <T> T[] getDTOArray(String jsonStr, Class<T> clazz) {
        List<T> dtoList = GsonUtil.getDTOList(jsonStr, clazz);
        Object[] obj = dtoList.toArray();
        return obj;
    }
}

