/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JAXBUtil {
    private JAXBUtil() {
    }

    public static Object unmarshall(String xml, Class clsToUnbound) throws JAXBException, UnsupportedEncodingException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clsToUnbound});
        return JAXBUtil.unmarshall(jc, xml);
    }

    private static Object unmarshall(JAXBContext jc, String xml) throws JAXBException, UnsupportedEncodingException {
        Unmarshaller u = jc.createUnmarshaller();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        return u.unmarshal((InputStream)is);
    }

    public static Object unmarshall(InputStream xmlIs, Class<?> cls) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{cls});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return unmarshaller.unmarshal(xmlIs);
    }

    public Object unmarshall(String xml, Class<? extends Object> ... classes) throws JAXBException {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        JAXBContext jc = JAXBContext.newInstance((Class[])classes);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        return unmarshaller.unmarshal((InputStream)is);
    }

    public static String marshall(Object pojo, Class clsToBound) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clsToBound});
        return JAXBUtil.marshall(jc, pojo);
    }

    public static String marshall(Object pojo, Class clsToBound, String charset) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clsToBound});
        return JAXBUtil.marshall(jc, pojo, charset);
    }

    private static String marshall(JAXBContext jc, Object serObj) throws JAXBException {
        return JAXBUtil.marshall(jc, serObj, System.getProperty("file.encoding"));
    }

    private static String marshall(JAXBContext jc, Object serObj, String charset) throws JAXBException {
        StringWriter out = new StringWriter();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)charset);
        m.marshal(serObj, (Writer)out);
        return out.toString();
    }

    public static void marshall(String contextPath, Object obj, OutputStream stream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)contextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal(obj, stream);
    }
}

