/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger logger = LoggerFactory.getLogger(NetUtil.class);
    private static final String DEFAULT_LOCALHOST = "localhost";
    private static final String DEFAULT_LOCALHOST_IP = "127.0.0.1";
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_PING_TIMES = 4;

    public static String getHostAddressByName(String domain) {
        try {
            InetAddress addr = InetAddress.getByName(domain);
            String hostAddr = addr.getHostAddress();
            return hostAddr;
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean ping(String host) {
        return NetUtil.ping(host, 3000);
    }

    public static boolean ping(String host, int timeout) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            if (logger.isDebugEnabled()) {
                logger.debug("host address is {}.", (Object)addr.getHostAddress());
            }
            return addr.isReachable(timeout);
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean pingCmd(String host) {
        return NetUtil.pingCmd(host, 4, 3000);
    }

    public static boolean pingCmd(String host, int timeout) {
        return NetUtil.pingCmd(host, 4, timeout);
    }

    public static boolean pingCmd(String host, int pingTimes, int timeout) {
        if (DEFAULT_LOCALHOST.equalsIgnoreCase(host)) {
            host = DEFAULT_LOCALHOST_IP;
        }
        BufferedReader in = null;
        Runtime rt = Runtime.getRuntime();
        StringBuilder cmd = new StringBuilder();
        cmd.append("ping ").append(host);
        cmd.append(" -n ").append(pingTimes);
        cmd.append(" -w ").append(timeout);
        try {
            Process pro;
            if (logger.isDebugEnabled()) {
                logger.debug("cmd ==> {}.", (Object)cmd.toString());
            }
            if (null == (pro = rt.exec(cmd.toString()))) {
                return false;
            }
            in = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            int connectedCount = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                connectedCount += NetUtil.getCheckResult(line);
            }
            return connectedCount == pingTimes;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static int getCheckResult(String line) {
        Pattern pattern = Pattern.compile("(TTL=\\d+)", 2);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 1;
        }
        return 0;
    }
}

