/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.util.string.StringUtil;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class ScheduledUtil {
    public static final String DEFAULT_THREAD_GROUP_NAME = "apaas-thread";

    public static ThreadFactory getThreadFactory(final String threadGroupName) {
        if (StringUtil.isBlank((CharSequence)threadGroupName)) {
            return ScheduledUtil.getThreadFactory();
        }
        return new ThreadFactory(){
            private final AtomicLong threadNumber = new AtomicLong(1L);

            @Override
            public Thread newThread(Runnable runnable) {
                ThreadGroup threadGroup = new ThreadGroup(threadGroupName);
                Thread thread = new Thread(threadGroup, runnable, threadGroup.getName() + "-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        };
    }

    public static ThreadFactory getThreadFactory() {
        return new ThreadFactory(){
            private final AtomicLong threadNumber = new AtomicLong(1L);

            @Override
            public Thread newThread(Runnable runnable) {
                ThreadGroup threadGroup = new ThreadGroup(ScheduledUtil.DEFAULT_THREAD_GROUP_NAME);
                Thread thread = new Thread(threadGroup, runnable, threadGroup.getName() + "-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        };
    }

    public static void createAndRunningScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, long delay, long period, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        pool.scheduleWithFixedDelay(() -> {
            if (execution == null) {
                return;
            }
            execution.apply(null);
        }, delay, period, timeUnit);
    }

    public static void createAndRunningScheduledThreadPoolExecutor(int corePoolSize, String threadGroupName, long delay, long period, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory(threadGroupName));
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        pool.scheduleWithFixedDelay(() -> {
            if (execution == null) {
                return;
            }
            execution.apply(null);
        }, delay, period, timeUnit);
    }

    public static void createAndRunningScheduledThreadPoolExecutor(int corePoolSize, long delay, long period, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory());
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        pool.scheduleWithFixedDelay(() -> {
            if (execution == null) {
                return;
            }
            execution.apply(null);
        }, delay, period, timeUnit);
    }

    public static void createAndRunningOnceThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, long delay, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        pool.schedule(() -> {
            if (execution == null) {
                return;
            }
            execution.apply(null);
        }, delay, timeUnit);
    }

    public static void createAndRunningOnceThreadPoolExecutor(int corePoolSize, String threadGroupName, long delay, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory(threadGroupName));
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        pool.schedule(() -> {
            if (execution == null) {
                return;
            }
            execution.apply(null);
        }, delay, timeUnit);
    }

    public static void createAndRunningOnceThreadPoolExecutor(int corePoolSize, long delay, TimeUnit timeUnit, Function<Void, Void> execution) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(corePoolSize, ScheduledUtil.getThreadFactory());
        delay = delay < 0L ? 5L : delay;
        timeUnit = timeUnit == null ? TimeUnit.MINUTES : timeUnit;
        pool.schedule(() -> {
            if (execution == null) {
                return;
            }
            execution.apply(null);
        }, delay, timeUnit);
    }
}

