/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import com.hy.apaas.base.core.exception.BaseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtil {
    private static Logger logger = LoggerFactory.getLogger(SerializeUtil.class);

    private SerializeUtil() {
    }

    public static <T> T decodeObject(byte[] b) {
        return (T)SerializeUtil.deserialize(SerializeUtil.decompress(b));
    }

    public static byte[] encodeObject(Object o) {
        return SerializeUtil.compress(SerializeUtil.serialize(o));
    }

    private static byte[] serialize(Object o) {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("Non-serializable object: " + o.getClass().getName(), e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(os);
                CloseUtil.close(bos);
                throw throwable;
            }
        }
        CloseUtil.close(os);
        CloseUtil.close(bos);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Object deserialize(byte[] in) {
        ObjectInputStream is;
        ByteArrayInputStream bis;
        Object rv;
        block6: {
            rv = null;
            bis = null;
            is = null;
            int len = 0;
            try {
                if (in == null) break block6;
                len = in.length;
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
            catch (IOException e) {
                logger.warn("Caught IOException decoding " + len + " bytes of data", (Throwable)e);
                CloseUtil.close(is);
                CloseUtil.close(bis);
            }
            catch (ClassNotFoundException e2) {
                logger.warn("Caught CNFE decoding " + len + " bytes of data", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        CloseUtil.close(is);
                        CloseUtil.close(bis);
                        throw throwable;
                    }
                }
                CloseUtil.close(is);
                CloseUtil.close(bis);
            }
        }
        CloseUtil.close(is);
        CloseUtil.close(bis);
        return rv;
    }

    private static byte[] compress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            try {
                throw new BaseException("IO exception compressing data", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(gz);
                CloseUtil.close(bos);
                throw throwable;
            }
        }
        CloseUtil.close(gz);
        CloseUtil.close(bos);
        byte[] rv = bos.toByteArray();
        if (logger.isDebugEnabled()) {
            logger.debug("Compressed " + in.length + " bytes to " + rv.length);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            GZIPInputStream gis = null;
            try {
                gis = new GZIPInputStream(bis);
                byte[] buf = new byte[8192];
                int r = -1;
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                try {
                    logger.warn("Failed to decompress data", (Throwable)e);
                    bos = null;
                }
                catch (Throwable throwable) {
                    CloseUtil.close(gis);
                    CloseUtil.close(bis);
                    CloseUtil.close(bos);
                    throw throwable;
                }
                CloseUtil.close(gis);
                CloseUtil.close(bis);
                CloseUtil.close(bos);
            }
            CloseUtil.close(gis);
            CloseUtil.close(bis);
            CloseUtil.close(bos);
        }
        return bos == null ? null : bos.toByteArray();
    }

    private static final class CloseUtil {
        private CloseUtil() {
        }

        public static void close(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    logger.warn("Unable to close " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

