/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ThreadUtil {
    public static final int DEFAULT_THREAD_COUNT = 100;
    public static final int THREAD_TYPE_DEFAULT = 3;
    public static final int THREAD_TYPE_SINGLE = 1;
    public static final int THREAD_TYPE_FIXED = 2;
    public static final int THREAD_TYPE_CACHED = 3;
    private static ExecutorService singleThreadExecutor = null;
    private static ExecutorService fixedThreadPool = null;
    private static ExecutorService cachedThreadPool = null;

    private ThreadUtil() {
    }

    public static void initSingleThreadExecutor() {
        singleThreadExecutor = Executors.newSingleThreadExecutor();
    }

    public static void initFixedThreadPool(int nThreads) {
        fixedThreadPool = Executors.newFixedThreadPool(nThreads);
    }

    public static void initCachedThreadPool() {
        cachedThreadPool = Executors.newCachedThreadPool();
    }

    public static void execute(int type, Runnable runnable) {
        switch (type) {
            case 1: {
                if (null == singleThreadExecutor) {
                    ThreadUtil.initSingleThreadExecutor();
                }
                singleThreadExecutor.execute(runnable);
                break;
            }
            case 2: {
                if (null == fixedThreadPool) {
                    ThreadUtil.initFixedThreadPool(100);
                }
                fixedThreadPool.execute(runnable);
                break;
            }
            case 3: {
                if (null == cachedThreadPool) {
                    ThreadUtil.initCachedThreadPool();
                }
                cachedThreadPool.execute(runnable);
                break;
            }
            default: {
                if (null == singleThreadExecutor) {
                    ThreadUtil.initSingleThreadExecutor();
                }
                singleThreadExecutor.execute(runnable);
            }
        }
    }
}

