/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.hy.apaas.base.core.util.string.StringUtil;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class SqlDateSerializer
implements JsonSerializer<Date> {
    private String format = "yyyy-MM-dd HH:mm:ss";

    public SqlDateSerializer() {
    }

    public SqlDateSerializer(String format) {
        if (StringUtil.isNotBlank((CharSequence)format)) {
            this.format = format;
        }
    }

    public JsonElement serialize(Date src, Type arg1, JsonSerializationContext arg2) {
        SimpleDateFormat df = new SimpleDateFormat(this.format);
        String dateFormatAsString = df.format(new Date(src.getTime()));
        return new JsonPrimitive(dateFormatAsString);
    }
}

