/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.string;

import com.hy.apaas.base.core.util.string.StringUtil;

public class StringDBUtil {
    private StringDBUtil() {
    }

    public static String dbFieldToField(String dbField) {
        return StringDBUtil.dbFieldToField(dbField, "_", true);
    }

    public static String dbFieldToField(String dbField, String symbol, boolean upperExceptFirst) {
        StringBuilder result = new StringBuilder();
        if (dbField.startsWith(symbol)) {
            dbField = dbField.substring(1);
        }
        if (dbField.endsWith(symbol)) {
            dbField = dbField.substring(0, dbField.length() - 1);
        }
        String[] arr = dbField.split(symbol);
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            if (upperExceptFirst && i != 0) {
                char oldChar = str.charAt(0);
                char newChar = Character.toString(oldChar).toUpperCase().charAt(0);
                str = newChar + str.substring(1);
            }
            result.append(str);
        }
        return result.toString();
    }

    public static String fieldToDbField(String field, String symbol, String caseType, boolean lastUnderScore) {
        if (StringUtil.isEmpty((CharSequence)field)) {
            return "";
        }
        int len = field.length();
        StringBuilder fieldBuilder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = field.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                fieldBuilder.append(symbol);
                fieldBuilder.append(c);
                continue;
            }
            fieldBuilder.append(c);
        }
        if (lastUnderScore) {
            fieldBuilder.append(symbol);
        }
        switch (caseType) {
            case "upper": {
                return fieldBuilder.toString().toUpperCase();
            }
            case "lower": {
                return fieldBuilder.toString().toLowerCase();
            }
        }
        return fieldBuilder.toString();
    }

    public static String fieldToDbField(String field) {
        return StringDBUtil.fieldToDbField(field, "_", "lower", true);
    }
}

