/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.string;

import com.hy.apaas.base.core.exception.BaseException;
import com.hy.apaas.base.core.util.BeanUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private StringUtil() {
    }

    public static String build(Object ... objs) {
        StringBuilder builder = new StringBuilder();
        if (BeanUtils.isNotEmpty(objs)) {
            for (Object obj : objs) {
                builder.append(obj);
            }
        }
        return builder.toString();
    }

    public static boolean isExistIgnoreCase(String content, String beginStr, String endStr) {
        boolean isExist = true;
        String lowContent = content.toLowerCase();
        String lowBeginStr = beginStr.toLowerCase();
        String lowEndStr = endStr.toLowerCase();
        int beginIndex = lowContent.indexOf(lowBeginStr);
        int endIndex = lowContent.indexOf(lowEndStr);
        return beginIndex != -1 && endIndex != -1 && beginIndex < endIndex;
    }

    public static String trimPrefix(String content, String prefix) {
        String resultStr = content;
        while (resultStr.startsWith(prefix)) {
            resultStr = resultStr.substring(prefix.length());
        }
        return resultStr;
    }

    public static String trimSuffix(String content, String suffix) {
        String resultStr = content;
        while (resultStr.endsWith(suffix)) {
            resultStr = resultStr.substring(0, resultStr.length() - suffix.length());
        }
        return resultStr;
    }

    public static String trimBoth(String content, String trimStr) {
        return StringUtil.trimSuffix(StringUtil.trimPrefix(content, trimStr), trimStr);
    }

    public static String upperFirst(String str) {
        return StringUtil.convertFirst(str, true);
    }

    public static String lowerFirst(String str) {
        return StringUtil.convertFirst(str, false);
    }

    public static String removeSpecialChars(String content) {
        Pattern p = Pattern.compile("[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]");
        Matcher m = p.matcher(content);
        return m.replaceAll("").trim();
    }

    public static String convertFirst(String str, boolean isUpper) {
        if (StringUtil.isEmpty((CharSequence)str)) {
            return "";
        }
        char first = str.charAt(0);
        String firstChar = new String(new char[]{first});
        firstChar = isUpper ? firstChar.toUpperCase() : firstChar.toLowerCase();
        return firstChar + str.substring(1);
    }

    public static String convertSplit(String str, String split) {
        if (StringUtil.isEmpty((CharSequence)str)) {
            return "";
        }
        if (StringUtil.isEmpty((CharSequence)split)) {
            return "_";
        }
        Object[] strArr = (str = str.toLowerCase()).split(split);
        if (strArr.length == 1) {
            return strArr[0];
        }
        int len = strArr.length;
        for (int i = 1; i < len; ++i) {
            strArr[i] = StringUtil.upperFirst((String)strArr[i]);
        }
        return StringUtil.join((Object[])strArr, (String)"");
    }

    public static String replaceVariable(String template, Map<String, String> map) {
        return StringUtil.replaceVariable(template, map, false);
    }

    public static String replaceVariable(String template, Map<String, String> map, Boolean isException) {
        Pattern regex = Pattern.compile("\\{(.*?)\\}");
        Matcher regexMatcher = regex.matcher(template);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            String value = map.get(key);
            if (value != null) {
                template = template.replace(toReplace, value);
                continue;
            }
            if (!isException.booleanValue()) continue;
            throw new BaseException("\u6ca1\u6709\u627e\u5230[" + key + "]\u5bf9\u5e94\u7684\u53d8\u91cf\u503c\uff0c\u8bf7\u68c0\u67e5\u8868\u53d8\u91cf\u914d\u7f6e!");
        }
        return template;
    }

    public static String replaceVariable(String template, String tableName) {
        Pattern regex = Pattern.compile("\\{(.*?)\\}");
        Matcher regexMatcher = regex.matcher(template);
        if (regexMatcher.find()) {
            String toReplace = regexMatcher.group(0);
            template = template.replace(toReplace, tableName);
        }
        return template;
    }

    public static String trimSufffix(String toTrim, String trimStr) {
        while (toTrim.endsWith(trimStr)) {
            toTrim = toTrim.substring(0, toTrim.length() - trimStr.length());
        }
        return toTrim;
    }

    public static String trim(String toTrim, String trimStr) {
        return StringUtil.trimSufffix(StringUtil.trimPrefix(toTrim, trimStr), trimStr);
    }

    public static String combilePath(String baseDir, String dir) {
        baseDir = StringUtil.trimSufffix(baseDir, File.separator);
        dir = StringUtil.trimPrefix(dir, File.separator);
        return baseDir + File.separator + dir;
    }

    public static String pathJoin(String ... args) {
        int j;
        StringBuilder result = new StringBuilder();
        int n = j = args == null ? 0 : args.length;
        for (int i = 0; i < j; ++i) {
            String str = args[i];
            if (str == null) {
                str = "";
            }
            if (i > 0 && (str.startsWith("/") || str.startsWith("\\"))) {
                str = str.substring(1);
            }
            result.append(str);
            if (i + 1 >= j || str.endsWith("/") || str.endsWith("\\")) continue;
            result.append("/");
        }
        return result.toString();
    }

    public static Boolean arrayStringContains(String string, String subString) {
        if (StringUtil.isEmpty((CharSequence)string) || StringUtil.isEmpty((CharSequence)subString)) {
            return false;
        }
        return Arrays.asList(string.split(",")).contains(subString);
    }
}

