/*
 * Decompiled with CFR 0.152.
 */
package com.hy.apaas.base.core.util.time;

import com.hy.apaas.base.core.exception.BaseException;
import com.hy.apaas.base.core.util.BeanUtils;
import com.hy.apaas.base.core.util.time.DateFormatUtil;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(TimeUtil.class);

    private TimeUtil() {
    }

    public static String getDate(long time, String format) {
        return DateFormatUtil.format(new Date(time), format);
    }

    public static boolean isTimeLarge(String startTime, String endTime) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = formatter.parse(startTime, pos);
            Date dt2 = formatter.parse(endTime, pos1);
            long lDiff = dt2.getTime() - dt1.getTime();
            return lDiff > 0L;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static long getTime(Date startTime, Date endTime) {
        return endTime.getTime() - startTime.getTime();
    }

    public static String getTimeDiff(String startTime, String endTime) {
        try {
            int hours;
            String tmp = "";
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = formatter.parse(startTime, pos);
            Date dt2 = formatter.parse(endTime, pos1);
            long lDiff = dt2.getTime() - dt1.getTime();
            int days = (int)(lDiff / 86400000L);
            if (days > 0) {
                lDiff -= (long)(days * 1000 * 60 * 60 * 24);
                tmp = tmp + days + "\u5929";
            }
            if ((hours = (int)(lDiff / 3600000L)) > 0) {
                lDiff -= (long)(hours * 1000 * 60 * 60);
            }
            tmp = tmp + hours + "\u5c0f\u65f6";
            int minute = (int)(lDiff / 60000L);
            tmp = tmp + minute + "\u5206\u949f";
            return tmp;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "-1";
        }
    }

    public static String getTime(Long millseconds) {
        long minuteMillseconds;
        int minutes;
        long hourMillseconds;
        int hours;
        String time = "";
        if (millseconds == null) {
            return "";
        }
        int days = (int)millseconds.longValue() / 1000 / 60 / 60 / 24;
        if (days > 0) {
            time = time + days + "\u5929";
        }
        if ((hours = (int)(hourMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24)) / 1000 / 60 / 60) > 0) {
            time = time + hours + "\u5c0f\u65f6";
        }
        if ((minutes = (int)(minuteMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24) - (long)(hours * 1000 * 60 * 60)) / 1000 / 60) > 0) {
            time = time + minutes + "\u5206\u949f";
        }
        return time;
    }

    public static String getTime2(Long millseconds) {
        long secondMillseconds;
        int seconds;
        long minuteMillseconds;
        int minutes;
        long hourMillseconds;
        int hours;
        String time = "";
        if (millseconds == null) {
            return "";
        }
        int days = (int)millseconds.longValue() / 1000 / 60 / 60 / 24;
        if (days > 0) {
            time = time + days + "\u5929";
        }
        if ((hours = (int)(hourMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24)) / 1000 / 60 / 60) > 0) {
            time = time + hours + "\u5c0f\u65f6";
        }
        if ((minutes = (int)(minuteMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24) - (long)(hours * 1000 * 60 * 60)) / 1000 / 60) > 0) {
            time = time + minutes + "\u5206\u949f";
        }
        if ((seconds = (int)(secondMillseconds = millseconds - (long)(days * 1000 * 60 * 60 * 24) - (long)(hours * 1000 * 60 * 60) - (long)(minutes * 1000 * 60)) / 1000) > 0) {
            time = time + seconds + "\u79d2";
        }
        return time;
    }

    public static String getDateString(long millseconds) {
        return DateFormatUtil.format(millseconds, "yyyy-MM-dd");
    }

    public static long getNextDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        String str = String.valueOf(cal.getTimeInMillis());
        return Long.parseLong(str.substring(0, str.length() - 3) + "000");
    }

    public static Date getNextDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date getNextDaysMillis(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        Long time = cal.getTimeInMillis() - 1L;
        return new Date(time);
    }

    public static long getMillsByDateString(String strDate) {
        Calendar cal = Calendar.getInstance();
        if (strDate != null && strDate.trim().length() > 9) {
            strDate = strDate.trim();
            try {
                int year = Integer.parseInt(strDate.substring(0, 4));
                int month = Integer.parseInt(strDate.substring(5, 7)) - 1;
                int date = Integer.parseInt(strDate.substring(8, 10));
                cal.set(year, month, date, 0, 0, 0);
                String str = String.valueOf(cal.getTimeInMillis());
                return Long.parseLong(str.substring(0, str.length() - 3) + "000");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    public static long getMillsByDateTimeString(String strDateTime) {
        Calendar cal = Calendar.getInstance();
        if (strDateTime != null && strDateTime.trim().length() > 18) {
            strDateTime = strDateTime.trim();
            try {
                int year = Integer.parseInt(strDateTime.substring(0, 4));
                int month = Integer.parseInt(strDateTime.substring(5, 7)) - 1;
                int date = Integer.parseInt(strDateTime.substring(8, 10));
                int hour = Integer.parseInt(strDateTime.substring(11, 13));
                int minute = Integer.parseInt(strDateTime.substring(14, 16));
                int second = Integer.parseInt(strDateTime.substring(17, 19));
                cal.set(year, month, date, hour, minute, second);
                return cal.getTimeInMillis();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    public static String getFormatString(long millseconds, String format) {
        if (format == null || format.trim().length() == 0) {
            format = "yyyy-MM-dd";
        }
        format = format.trim();
        return DateFormatUtil.format(millseconds, format);
    }

    public static long getCurrentTimeMillis() {
        Calendar c = Calendar.getInstance();
        return c.getTimeInMillis();
    }

    public static String getTimeByMills(long mills) {
        try {
            if (mills == 0L) {
                return "-";
            }
            Date date = null;
            Calendar ca = Calendar.getInstance();
            ca.setTimeInMillis(mills);
            date = ca.getTime();
            if (ca.get(11) == 0 && ca.get(12) == 0 && ca.get(13) == 0) {
                return DateFormatUtil.formatDate(date);
            }
            return DateFormatUtil.formatDateTime(date);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "-";
        }
    }

    public static String formatDate(long mills) {
        try {
            if (mills == 0L) {
                return "-";
            }
            Date date = null;
            Calendar ca = Calendar.getInstance();
            ca.setTimeInMillis(mills);
            date = ca.getTime();
            return DateFormatUtil.formatDate(date);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "-";
        }
    }

    public static String formatTime(long mills) {
        try {
            if (mills == 0L) {
                return "-";
            }
            Date date = null;
            Calendar ca = Calendar.getInstance();
            ca.setTimeInMillis(mills);
            date = ca.getTime();
            return DateFormatUtil.formatDateTime(date);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "-";
        }
    }

    public static long getMillsByTime(String strTime) {
        try {
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minute = 0;
            int second = 0;
            if (strTime.length() != 19 && strTime.length() != 10) {
                throw new BaseException("the time string is wrong.");
            }
            year = Integer.parseInt(strTime.substring(0, 4));
            month = Integer.parseInt(strTime.substring(5, 7)) - 1;
            day = Integer.parseInt(strTime.substring(8, 10));
            if (year < 1000 || year > 3000) {
                throw new BaseException("the year is wrong.");
            }
            if (month < 0 || month > 12) {
                throw new BaseException("the month is wrong.");
            }
            if (day < 1 || day > 31) {
                throw new BaseException("the day is wrong");
            }
            Calendar ca = Calendar.getInstance();
            if (strTime.length() == 19) {
                hour = Integer.parseInt(strTime.substring(11, 13));
                minute = Integer.parseInt(strTime.substring(14, 16));
                second = Integer.parseInt(strTime.substring(17, 19));
                if (hour < 0 || hour > 24) {
                    throw new BaseException("the hour is wrong.");
                }
                if (minute < 0 || minute > 60) {
                    throw new BaseException("the minute is wrong.");
                }
                if (second < 0 || second > 60) {
                    throw new BaseException("the second is wrong.");
                }
                ca.set(year, month, day, hour, minute, second);
            } else if (strTime.length() == 10) {
                ca.set(year, month, day, 0, 0, 0);
            }
            return ca.getTimeInMillis();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public static long getNextTime(int timeUnit, int interval, long timeMill) {
        Calendar ca = Calendar.getInstance();
        ca.setTimeInMillis(timeMill);
        ca.add(timeUnit, interval);
        return ca.getTimeInMillis();
    }

    public static Date getDateTimeByTimeString(String timeString) {
        Date date = new Date();
        try {
            date = DateFormatUtil.parse(timeString, "yy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return date;
    }

    public static Date getDateByDateString(String timeString) {
        Date date = new Date();
        try {
            date = DateFormatUtil.parse(timeString, "yy-MM-dd");
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return date;
    }

    public static Date getDate(int year, int month, int date) {
        return TimeUtil.getDate(year, month, date, 0, 0, 0);
    }

    public static Date getDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, date, hourOfDay, minute, second);
        return cal.getTime();
    }

    public static int getSecondDiff(Date endTime, Date startTime) {
        long start = startTime.getTime();
        long end = endTime.getTime();
        return (int)((end - start) / 1000L);
    }

    public static int getDaysOfMonth(int year, int mon) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, mon - 1);
        return cal.getActualMaximum(5);
    }

    public static int getWeekDayOfMonth(int year, int mon) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, mon - 1, 1);
        return cal.get(7);
    }

    public static String getDurationTime(Date time) {
        if (BeanUtils.isEmpty(time)) {
            return "";
        }
        Long millseconds = TimeUtil.getTime(time, new Date());
        return TimeUtil.getTime(millseconds);
    }
}

