/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency.serialize;

import com.alibaba.nacos.common.utils.ByteUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.consistency.Serializer;
import java.lang.reflect.Type;

public class JacksonSerializer
implements Serializer {
    private static final String NAME = "JSON";

    @Override
    public <T> T deserialize(byte[] data) {
        throw new UnsupportedOperationException("Jackson serializer can't support deserialize json without type");
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> cls) {
        if (ByteUtils.isEmpty((byte[])data)) {
            return null;
        }
        return (T)JacksonUtils.toObj((byte[])data, cls);
    }

    @Override
    public <T> T deserialize(byte[] data, Type type) {
        if (ByteUtils.isEmpty((byte[])data)) {
            return null;
        }
        return (T)JacksonUtils.toObj((byte[])data, (Type)type);
    }

    @Override
    public <T> byte[] serialize(T obj) {
        return JacksonUtils.toJsonBytes(obj);
    }

    @Override
    public String name() {
        return NAME;
    }
}

