/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.service;

import cn.stylefeng.roses.kernel.config.modular.pojo.param.SysConfigTypeParam;
import cn.stylefeng.roses.kernel.config.modular.service.SysConfigService;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.dict.api.DictTypeApi;
import cn.stylefeng.roses.kernel.dict.api.pojo.DictDetail;
import cn.stylefeng.roses.kernel.dict.api.pojo.SimpleDictUpdateParam;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConfigTypeService {
    @Resource
    private DictApi dictApi;
    @Resource
    private DictTypeApi dictTypeApi;
    @Resource
    private SysConfigService sysConfigService;

    public List<SimpleDict> getSysConfigTypeList(SysConfigTypeParam sysConfigTypeParam) {
        return this.dictApi.getDictDetailsByDictTypeCode("config_group", sysConfigTypeParam.getSearchText());
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(SysConfigTypeParam sysConfigTypeParam) {
        Long dictTypeId = this.dictTypeApi.getDictTypeIdByDictTypeCode("config_group");
        SimpleDictUpdateParam simpleDictAddParam = new SimpleDictUpdateParam();
        simpleDictAddParam.setDictTypeId(dictTypeId);
        simpleDictAddParam.setDictName(sysConfigTypeParam.getConfigTypeName());
        simpleDictAddParam.setDictCode(sysConfigTypeParam.getConfigTypeCode());
        simpleDictAddParam.setDictSort(sysConfigTypeParam.getConfigTypeSort());
        this.dictApi.simpleAddDict(simpleDictAddParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void edit(SysConfigTypeParam sysConfigTypeParam) {
        DictDetail originDictInfo = this.dictApi.getDictByDictId(sysConfigTypeParam.getConfigTypeId());
        Long dictTypeId = this.dictTypeApi.getDictTypeIdByDictTypeCode("config_group");
        SimpleDictUpdateParam simpleDictAddParam = new SimpleDictUpdateParam();
        simpleDictAddParam.setDictId(sysConfigTypeParam.getConfigTypeId());
        simpleDictAddParam.setDictTypeId(dictTypeId);
        simpleDictAddParam.setDictName(sysConfigTypeParam.getConfigTypeName());
        simpleDictAddParam.setDictCode(sysConfigTypeParam.getConfigTypeCode());
        simpleDictAddParam.setDictSort(sysConfigTypeParam.getConfigTypeSort());
        this.dictApi.simpleEditDict(simpleDictAddParam);
        if (!originDictInfo.getDictCode().equals(sysConfigTypeParam.getConfigTypeCode())) {
            this.sysConfigService.updateSysConfigTypeCode(originDictInfo.getDictCode(), sysConfigTypeParam.getConfigTypeCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(SysConfigTypeParam sysConfigTypeParam) {
        DictDetail originDictInfo = this.dictApi.getDictByDictId(sysConfigTypeParam.getConfigTypeId());
        this.dictApi.deleteByDictId(sysConfigTypeParam.getConfigTypeId());
        this.sysConfigService.delByConfigCode(originDictInfo.getDictCode());
    }

    public DictDetail detail(SysConfigTypeParam sysConfigTypeParam) {
        return this.dictApi.getDictByDictId(sysConfigTypeParam.getConfigTypeId());
    }
}

