/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.service.impl;

import cn.hutool.system.SystemUtil;
import cn.stylefeng.roses.kernel.config.api.enums.FileStorageTypeEnum;
import cn.stylefeng.roses.kernel.config.modular.pojo.newconfig.StorageConfig;
import cn.stylefeng.roses.kernel.config.modular.service.NewConfigService;
import cn.stylefeng.roses.kernel.config.modular.service.SysConfigService;
import cn.stylefeng.roses.kernel.rule.util.JarPathUtil;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NewConfigServiceImpl
implements NewConfigService {
    @Resource
    private SysConfigService sysConfigService;

    @Override
    public StorageConfig getStorageConfig() {
        StorageConfig storageConfig = new StorageConfig();
        String fileSaveType = this.sysConfigService.getConfigValueByCode("SYS_FILE_SAVE_TYPE");
        storageConfig.setFileSaveType(Integer.valueOf(fileSaveType));
        if (SystemUtil.getOsInfo().isWindows()) {
            String windowsPath = this.sysConfigService.getConfigValueByCode("SYS_LOCAL_FILE_SAVE_PATH_WINDOWS");
            storageConfig.setLocalFileSavePath(windowsPath);
        } else {
            String linuxPath = this.sysConfigService.getConfigValueByCode("SYS_LOCAL_FILE_SAVE_PATH_LINUX");
            storageConfig.setLocalFileSavePath(linuxPath);
        }
        return storageConfig;
    }

    @Override
    public void updateFileConfig(StorageConfig storageConfig) {
        String jarPath = null;
        if (FileStorageTypeEnum.LOCAL_DEFAULT.getCode().equals(storageConfig.getFileSaveType())) {
            jarPath = JarPathUtil.getJarPath();
        } else if (FileStorageTypeEnum.LOCAL.getCode().equals(storageConfig.getFileSaveType())) {
            jarPath = storageConfig.getLocalFileSavePath();
        }
        this.sysConfigService.updateConfigByCode("SYS_FILE_SAVE_TYPE", String.valueOf(storageConfig.getFileSaveType()));
        if (SystemUtil.getOsInfo().isWindows()) {
            this.sysConfigService.updateConfigByCode("SYS_LOCAL_FILE_SAVE_PATH_WINDOWS", jarPath);
        } else {
            this.sysConfigService.updateConfigByCode("SYS_LOCAL_FILE_SAVE_PATH_LINUX", jarPath);
        }
    }
}

